/*
 * Decompiled with CFR 0.152.
 */
package net.sf.minuteProject.architecture.validation.rule;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.minuteProject.architecture.holder.element.SimpleValidationError;
import org.apache.commons.lang.StringUtils;

public class SimpleRule {
    public static final String FIELD_MANDATORY_NOT_NULL = "FIELD_MANDATORY_NOT_NULL";
    public static final String INVALID_EMAIL = "INVALID_EMAIL";
    public static final String EMAIL_REGEX = "\\b[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}\\b";

    public static SimpleValidationError validateNotNull(Object o, String errorCode) {
        if (o == null) {
            return new SimpleValidationError(errorCode);
        }
        return null;
    }

    public static SimpleValidationError validateMandatoryNotBlank(String field) {
        return SimpleRule.validateMandatoryNotBlank(field, FIELD_MANDATORY_NOT_NULL);
    }

    public static SimpleValidationError validateMandatoryNotBlank(String field, String errorCode) {
        if (field != null && StringUtils.trimToNull((String)field) != null) {
            return null;
        }
        return new SimpleValidationError(errorCode);
    }

    public static SimpleValidationError validateEmail(String field) {
        return SimpleRule.validateEmail(field, INVALID_EMAIL);
    }

    public static SimpleValidationError validateEmail(String field, String errorCode) {
        return SimpleRule.validateAgainstRegex(field, EMAIL_REGEX, errorCode);
    }

    public static SimpleValidationError validateAgainstRegex(String field, String regex, String errorCode) {
        if (SimpleRule.validateAgainstRegex(field, regex)) {
            return null;
        }
        return new SimpleValidationError(errorCode);
    }

    public static boolean validateAgainstRegex(String field, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(field);
        return matcher.matches();
    }
}

