/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.util.Map;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.RenamedDataEntry;

public class DataEntryRenamer
implements DataEntryReader {
    private final Map nameMap;
    private final DataEntryReader renamedDataEntryReader;
    private final DataEntryReader missingDataEntryReader;

    public DataEntryRenamer(Map nameMap, DataEntryReader renamedDataEntryReader) {
        this(nameMap, renamedDataEntryReader, null);
    }

    public DataEntryRenamer(Map nameMap, DataEntryReader renamedDataEntryReader, DataEntryReader missingDataEntryReader) {
        this.nameMap = nameMap;
        this.renamedDataEntryReader = renamedDataEntryReader;
        this.missingDataEntryReader = missingDataEntryReader;
    }

    public void read(DataEntry dataEntry) throws IOException {
        String newName;
        String name = dataEntry.getName();
        if (dataEntry.isDirectory() && name.length() > 0) {
            name = name + '/';
        }
        if ((newName = (String)this.nameMap.get(name)) != null) {
            if (dataEntry.isDirectory() && newName.length() > 0) {
                newName = newName.substring(0, newName.length() - 1);
            }
            this.renamedDataEntryReader.read(new RenamedDataEntry(dataEntry, newName));
        } else if (this.missingDataEntryReader != null) {
            this.missingDataEntryReader.read(dataEntry);
        }
    }
}

