/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.Finisher;

public class JarWriter
implements DataEntryWriter,
Finisher {
    private final DataEntryWriter dataEntryWriter;
    private final Manifest manifest;
    private final String comment;
    private OutputStream currentParentOutputStream;
    private ZipOutputStream currentJarOutputStream;
    private Finisher currentFinisher;
    private DataEntry currentDataEntry;
    private final Set jarEntryNames = new HashSet();

    public JarWriter(DataEntryWriter dataEntryWriter) {
        this(dataEntryWriter, null, null);
    }

    public JarWriter(DataEntryWriter dataEntryWriter, Manifest manifest, String comment) {
        this.dataEntryWriter = dataEntryWriter;
        this.manifest = manifest;
        this.comment = comment;
    }

    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        if (!this.prepareEntry(dataEntry)) {
            return false;
        }
        this.closeEntry();
        String name = dataEntry.getName() + '/';
        if (this.jarEntryNames.add(name)) {
            this.currentJarOutputStream.putNextEntry(new ZipEntry(name));
            this.currentJarOutputStream.closeEntry();
        }
        this.currentFinisher = null;
        this.currentDataEntry = null;
        return true;
    }

    public OutputStream getOutputStream(DataEntry dataEntry) throws IOException {
        return this.getOutputStream(dataEntry, null);
    }

    public OutputStream getOutputStream(DataEntry dataEntry, Finisher finisher) throws IOException {
        if (!this.prepareEntry(dataEntry)) {
            return null;
        }
        if (!dataEntry.equals(this.currentDataEntry)) {
            this.closeEntry();
            String name = dataEntry.getName();
            if (!this.jarEntryNames.add(name)) {
                throw new IOException("Duplicate zip entry [" + dataEntry + "]");
            }
            this.currentJarOutputStream.putNextEntry(new ZipEntry(name));
            this.currentFinisher = finisher;
            this.currentDataEntry = dataEntry;
        }
        return this.currentJarOutputStream;
    }

    public void finish() throws IOException {
        if (this.currentJarOutputStream != null) {
            this.closeEntry();
            this.currentJarOutputStream.finish();
            this.currentJarOutputStream = null;
            this.currentParentOutputStream = null;
            this.jarEntryNames.clear();
        }
    }

    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    private boolean prepareEntry(DataEntry dataEntry) throws IOException {
        OutputStream parentOutputStream = this.dataEntryWriter.getOutputStream(dataEntry.getParent(), this);
        if (parentOutputStream == null) {
            return false;
        }
        if (this.currentParentOutputStream == null) {
            this.currentParentOutputStream = parentOutputStream;
            ZipOutputStream zipOutputStream = this.currentJarOutputStream = this.manifest != null ? new JarOutputStream(parentOutputStream, this.manifest) : new ZipOutputStream(parentOutputStream);
            if (this.comment != null) {
                this.currentJarOutputStream.setComment(this.comment);
            }
        }
        return true;
    }

    private void closeEntry() throws IOException {
        if (this.currentDataEntry != null) {
            if (this.currentFinisher != null) {
                this.currentFinisher.finish();
                this.currentFinisher = null;
            }
            this.currentJarOutputStream.closeEntry();
            this.currentDataEntry = null;
        }
    }
}

