/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.ArrayList;
import java.util.List;
import proguard.obfuscate.NameFactory;

public class SimpleNameFactory
implements NameFactory {
    private static final int CHARACTER_COUNT = 26;
    private static final List cachedMixedCaseNames = new ArrayList();
    private static final List cachedLowerCaseNames = new ArrayList();
    private final boolean generateMixedCaseNames;
    private int index = 0;

    public SimpleNameFactory() {
        this(true);
    }

    public SimpleNameFactory(boolean generateMixedCaseNames) {
        this.generateMixedCaseNames = generateMixedCaseNames;
    }

    public void reset() {
        this.index = 0;
    }

    public String nextName() {
        return this.name(this.index++);
    }

    private String name(int index) {
        List cachedNames;
        List list = cachedNames = this.generateMixedCaseNames ? cachedMixedCaseNames : cachedLowerCaseNames;
        if (index < cachedNames.size()) {
            return (String)cachedNames.get(index);
        }
        String name = this.newName(index);
        cachedNames.add(index, name);
        return name;
    }

    private String newName(int index) {
        int totalCharacterCount = this.generateMixedCaseNames ? 52 : 26;
        int baseIndex = index / totalCharacterCount;
        int offset = index % totalCharacterCount;
        char newChar = this.charAt(offset);
        String newName = baseIndex == 0 ? new String(new char[]{newChar}) : this.name(baseIndex - 1) + newChar;
        return newName;
    }

    private char charAt(int index) {
        return (char)((index < 26 ? 97 : 39) + index);
    }

    public static void main(String[] args) {
        System.out.println("Some mixed-case names:");
        SimpleNameFactory.printNameSamples(new SimpleNameFactory(true), 60);
        System.out.println("Some lower-case names:");
        SimpleNameFactory.printNameSamples(new SimpleNameFactory(false), 60);
        System.out.println("Some more mixed-case names:");
        SimpleNameFactory.printNameSamples(new SimpleNameFactory(true), 80);
        System.out.println("Some more lower-case names:");
        SimpleNameFactory.printNameSamples(new SimpleNameFactory(false), 80);
    }

    private static void printNameSamples(SimpleNameFactory factory, int count) {
        for (int counter = 0; counter < count; ++counter) {
            System.out.println("  [" + factory.nextName() + "]");
        }
    }
}

