/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import proguard.Configuration;
import proguard.DescriptorKeepChecker;
import proguard.FullyQualifiedClassNameChecker;
import proguard.KeepClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.DynamicClassReferenceInitializer;
import proguard.classfile.util.DynamicMemberReferenceInitializer;
import proguard.classfile.util.StringReferenceInitializer;
import proguard.classfile.util.StringSharer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.LibraryClassFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class Initializer {
    private final Configuration configuration;

    public Initializer(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        int memberReferenceWarningCount;
        int dependencyWarningCount;
        int classReferenceWarningCount;
        int getmemberNoteCount;
        int classForNameNoteCount;
        int dynamicClassReferenceNoteCount;
        int descriptorNoteCount;
        int originalLibraryClassPoolSize = libraryClassPool.size();
        ClassPool reducedLibraryClassPool = this.configuration.useUniqueClassMemberNames ? null : new ClassPool();
        WarningPrinter classReferenceWarningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        WarningPrinter dependencyWarningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        programClassPool.classesAccept(new ClassSuperHierarchyInitializer(programClassPool, libraryClassPool, classReferenceWarningPrinter, null));
        libraryClassPool.classesAccept(new ClassSuperHierarchyInitializer(programClassPool, libraryClassPool, null, dependencyWarningPrinter));
        WarningPrinter memberReferenceWarningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        programClassPool.classesAccept(new ClassReferenceInitializer(programClassPool, libraryClassPool, classReferenceWarningPrinter, memberReferenceWarningPrinter, null));
        if (reducedLibraryClassPool != null) {
            programClassPool.classesAccept(new ReferencedClassVisitor(new LibraryClassFilter(new ClassPoolFiller(reducedLibraryClassPool))));
            reducedLibraryClassPool.classesAccept(new ClassSuperHierarchyInitializer(programClassPool, libraryClassPool, classReferenceWarningPrinter, null));
        }
        WarningPrinter dynamicClassReferenceNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        WarningPrinter classForNameNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DynamicClassReferenceInitializer(programClassPool, libraryClassPool, dynamicClassReferenceNotePrinter, null, classForNameNotePrinter, this.createClassNoteExceptionMatcher(this.configuration.keep))))));
        WarningPrinter getMemberNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DynamicMemberReferenceInitializer(programClassPool, libraryClassPool, getMemberNotePrinter, this.createClassMemberNoteExceptionMatcher(this.configuration.keep, true), this.createClassMemberNoteExceptionMatcher(this.configuration.keep, false))))));
        if (this.configuration.adaptClassStrings != null) {
            programClassPool.classesAccept(new ClassNameFilter(this.configuration.adaptClassStrings, (ClassVisitor)new AllConstantVisitor(new StringReferenceInitializer(programClassPool, libraryClassPool))));
        }
        WarningPrinter fullyQualifiedClassNameNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        WarningPrinter descriptorKeepNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        new FullyQualifiedClassNameChecker(programClassPool, libraryClassPool, fullyQualifiedClassNameNotePrinter).checkClassSpecifications(this.configuration.keep);
        new DescriptorKeepChecker(programClassPool, libraryClassPool, descriptorKeepNotePrinter).checkClassSpecifications(this.configuration.keep);
        if (reducedLibraryClassPool != null) {
            programClassPool.classesAccept(new ReferencedClassVisitor(new LibraryClassFilter(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(reducedLibraryClassPool))))));
            reducedLibraryClassPool.classesAccept(new ClassReferenceInitializer(programClassPool, libraryClassPool, null, null, dependencyWarningPrinter));
            libraryClassPool.clear();
            reducedLibraryClassPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(libraryClassPool))), new ReferencedClassVisitor(new LibraryClassFilter(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(libraryClassPool)))))}));
        } else {
            libraryClassPool.classesAccept(new ClassReferenceInitializer(programClassPool, libraryClassPool, null, null, dependencyWarningPrinter));
        }
        programClassPool.classesAccept(new ClassSubHierarchyInitializer());
        libraryClassPool.classesAccept(new ClassSubHierarchyInitializer());
        programClassPool.classesAccept(new StringSharer());
        libraryClassPool.classesAccept(new StringSharer());
        int fullyQualifiedNoteCount = fullyQualifiedClassNameNotePrinter.getWarningCount();
        if (fullyQualifiedNoteCount > 0) {
            System.out.println("Note: there were " + fullyQualifiedNoteCount + " references to unknown classes.");
            System.out.println("      You should check your configuration for typos.");
        }
        if ((descriptorNoteCount = descriptorKeepNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + descriptorNoteCount + " unkept descriptor classes in kept class members.");
            System.out.println("      You should consider explicitly keeping the mentioned classes");
            System.out.println("      (using '-keep').");
        }
        if ((dynamicClassReferenceNoteCount = dynamicClassReferenceNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + dynamicClassReferenceNoteCount + " unresolved dynamic references to classes or interfaces.");
            System.err.println("      You should check if you need to specify additional program jars.");
        }
        if ((classForNameNoteCount = classForNameNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + classForNameNoteCount + " class casts of dynamically created class instances.");
            System.out.println("      You might consider explicitly keeping the mentioned classes and/or");
            System.out.println("      their implementations (using '-keep').");
        }
        if ((getmemberNoteCount = getMemberNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + getmemberNoteCount + " accesses to class members by means of introspection.");
            System.out.println("      You should consider explicitly keeping the mentioned class members");
            System.out.println("      (using '-keep' or '-keepclassmembers').");
        }
        if ((classReferenceWarningCount = classReferenceWarningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + classReferenceWarningCount + " unresolved references to classes or interfaces.");
            System.err.println("         You may need to specify additional library jars (using '-libraryjars'),");
            System.err.println("         or perhaps the '-dontskipnonpubliclibraryclasses' option.");
        }
        if ((dependencyWarningCount = dependencyWarningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + dependencyWarningCount + " instances of library classes depending on program classes.");
            System.err.println("         You must avoid such dependencies, since the program classes will");
            System.err.println("         be processed, while the library classes will remain unchanged.");
        }
        if ((memberReferenceWarningCount = memberReferenceWarningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + memberReferenceWarningCount + " unresolved references to program class members.");
            System.err.println("         Your input classes appear to be inconsistent.");
            System.err.println("         You may need to recompile them and try again.");
            System.err.println("         Alternatively, you may have to specify the options ");
            System.err.println("         '-dontskipnonpubliclibraryclasses' and/or");
            System.err.println("         '-dontskipnonpubliclibraryclassmembers'.");
        }
        if (!(classReferenceWarningCount <= 0 && dependencyWarningCount <= 0 && memberReferenceWarningCount <= 0 || this.configuration.ignoreWarnings)) {
            throw new IOException("Please correct the above warnings first.");
        }
        if ((this.configuration.note == null || !this.configuration.note.isEmpty()) && (this.configuration.warn != null && this.configuration.warn.isEmpty() || this.configuration.ignoreWarnings)) {
            System.out.println("Note: You're ignoring all warnings!");
        }
        if (this.configuration.verbose) {
            System.out.println("Ignoring unused library classes...");
            System.out.println("  Original number of library classes: " + originalLibraryClassPoolSize);
            System.out.println("  Final number of library classes:    " + libraryClassPool.size());
        }
    }

    private StringMatcher createClassNoteExceptionMatcher(List noteExceptions) {
        if (noteExceptions != null) {
            ArrayList<String> noteExceptionNames = new ArrayList<String>(noteExceptions.size());
            for (int index = 0; index < noteExceptions.size(); ++index) {
                String extendsClassName;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)noteExceptions.get(index);
                if (!keepClassSpecification.markClasses) continue;
                String className = keepClassSpecification.className;
                if (className != null) {
                    noteExceptionNames.add(className);
                }
                if ((extendsClassName = keepClassSpecification.extendsClassName) == null) continue;
                noteExceptionNames.add(extendsClassName);
            }
            if (noteExceptionNames.size() > 0) {
                return new ListParser(new ClassNameParser()).parse(noteExceptionNames);
            }
        }
        return null;
    }

    private StringMatcher createClassMemberNoteExceptionMatcher(List noteExceptions, boolean isField) {
        if (noteExceptions != null) {
            ArrayList<String> noteExceptionNames = new ArrayList<String>();
            for (int index = 0; index < noteExceptions.size(); ++index) {
                List memberSpecifications;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)noteExceptions.get(index);
                List list = memberSpecifications = isField ? keepClassSpecification.fieldSpecifications : keepClassSpecification.methodSpecifications;
                if (memberSpecifications == null) continue;
                for (int index2 = 0; index2 < memberSpecifications.size(); ++index2) {
                    MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index2);
                    String memberName = memberSpecification.name;
                    if (memberName == null) continue;
                    noteExceptionNames.add(memberName);
                }
            }
            if (noteExceptionNames.size() > 0) {
                return new ListParser(new ClassNameParser()).parse(noteExceptionNames);
            }
        }
        return null;
    }
}

