/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryWriterFactory;
import proguard.InputReader;
import proguard.classfile.ClassPool;
import proguard.classfile.util.ClassUtil;
import proguard.io.ClassFilter;
import proguard.io.ClassRewriter;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryObfuscator;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryRenamer;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryFilter;
import proguard.io.ManifestRewriter;
import proguard.io.NameFilter;

public class OutputWriter {
    private final Configuration configuration;

    public OutputWriter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool) throws IOException {
        ClassPath programJars = this.configuration.programJars;
        ClassPathEntry firstEntry = programJars.get(0);
        if (firstEntry.isOutput()) {
            throw new IOException("The output jar [" + firstEntry.getName() + "] must be specified after an input jar, or it will be empty.");
        }
        for (int index = 0; index < programJars.size() - 1; ++index) {
            ClassPathEntry entry = programJars.get(index);
            if (!entry.isOutput()) continue;
            if (entry.getFilter() == null && entry.getJarFilter() == null && entry.getWarFilter() == null && entry.getEarFilter() == null && entry.getZipFilter() == null && programJars.get(index + 1).isOutput()) {
                throw new IOException("The output jar [" + entry.getName() + "] must have a filter, or all subsequent jars will be empty.");
            }
            for (int inIndex = 0; inIndex < programJars.size(); ++inIndex) {
                ClassPathEntry otherEntry = programJars.get(inIndex);
                if (otherEntry.isOutput() || !entry.getFile().equals(otherEntry.getFile())) continue;
                throw new IOException("The output jar [" + entry.getName() + "] must be different from all input jars.");
            }
        }
        int firstInputIndex = 0;
        int lastInputIndex = 0;
        for (int index = 0; index < programJars.size(); ++index) {
            ClassPathEntry entry = programJars.get(index);
            if (!entry.isOutput()) {
                lastInputIndex = index;
                continue;
            }
            int nextIndex = index + 1;
            if (nextIndex != programJars.size() && programJars.get(nextIndex).isOutput()) continue;
            this.writeOutput(programClassPool, programJars, firstInputIndex, lastInputIndex + 1, nextIndex);
            firstInputIndex = nextIndex;
        }
    }

    private void writeOutput(ClassPool programClassPool, ClassPath classPath, int fromInputIndex, int fromOutputIndex, int toOutputIndex) throws IOException {
        try {
            DataEntryCopier resourceCopier;
            DataEntryWriter writer = DataEntryWriterFactory.createDataEntryWriter(classPath, fromOutputIndex, toOutputIndex);
            ClassRewriter classRewriter = new ClassRewriter(programClassPool, writer);
            DataEntryReader resourceRewriter = resourceCopier = new DataEntryCopier(writer);
            if (this.configuration.adaptResourceFileContents != null) {
                resourceRewriter = new NameFilter(this.configuration.adaptResourceFileContents, (DataEntryReader)new NameFilter("META-INF/**", (DataEntryReader)new ManifestRewriter(programClassPool, writer), (DataEntryReader)new DataEntryRewriter(programClassPool, writer)), resourceRewriter);
            }
            if (this.configuration.adaptResourceFileNames != null) {
                Map packagePrefixMap = OutputWriter.createPackagePrefixMap(programClassPool);
                resourceRewriter = new NameFilter(this.configuration.adaptResourceFileNames, (DataEntryReader)new DataEntryObfuscator(programClassPool, packagePrefixMap, resourceRewriter), resourceRewriter);
            }
            NameFilter directoryRewriter = null;
            if (this.configuration.keepDirectories != null) {
                Map packagePrefixMap = OutputWriter.createPackagePrefixMap(programClassPool);
                directoryRewriter = new NameFilter(this.configuration.keepDirectories, (DataEntryReader)new DataEntryRenamer(packagePrefixMap, resourceCopier, resourceCopier));
            }
            ClassFilter reader = new ClassFilter(classRewriter, (DataEntryReader)new DirectoryFilter(directoryRewriter, resourceRewriter));
            new InputReader(this.configuration).readInput("  Copying resources from program ", classPath, fromInputIndex, fromOutputIndex, reader);
            writer.close();
        }
        catch (IOException ex) {
            throw new IOException("Can't write [" + classPath.get(fromOutputIndex).getName() + "] (" + ex.getMessage() + ")");
        }
    }

    private static Map createPackagePrefixMap(ClassPool classPool) {
        HashMap<String, String> PackagePrefixMap = new HashMap<String, String>();
        Iterator iterator = classPool.classNames();
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            String PackagePrefix = ClassUtil.internalPackagePrefix(className);
            String mappedNewPackagePrefix = (String)PackagePrefixMap.get(PackagePrefix);
            if (mappedNewPackagePrefix != null && mappedNewPackagePrefix.equals(PackagePrefix)) continue;
            String newClassName = classPool.getClass(className).getName();
            String newPackagePrefix = ClassUtil.internalPackagePrefix(newClassName);
            PackagePrefixMap.put(PackagePrefix, newPackagePrefix);
        }
        return PackagePrefixMap;
    }
}

