/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.info.VariableUsageMarker;

public class VariableCleaner
extends SimplifiedVisitor
implements AttributeVisitor {
    private final VariableUsageMarker variableUsageMarker = new VariableUsageMarker();

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.variableUsageMarker.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.u2localVariableTableLength = this.removeEmptyLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeEmptyLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
    }

    private int removeEmptyLocalVariables(LocalVariableInfo[] localVariableInfos, int localVariableInfoCount, int maxLocals) {
        int index;
        int newIndex = 0;
        for (index = 0; index < localVariableInfoCount && index < maxLocals; ++index) {
            if (!this.variableUsageMarker.isVariableUsed(index)) continue;
            localVariableInfos[newIndex++] = localVariableInfos[index];
        }
        for (index = newIndex; index < localVariableInfoCount; ++index) {
            localVariableInfos[index] = null;
        }
        return newIndex;
    }

    private int removeEmptyLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfos, int localVariableTypeInfoCount, int maxLocals) {
        int index;
        int newIndex = 0;
        for (index = 0; index < localVariableTypeInfoCount && index < maxLocals; ++index) {
            if (!this.variableUsageMarker.isVariableUsed(index)) continue;
            localVariableTypeInfos[newIndex++] = localVariableTypeInfos[index];
        }
        for (index = newIndex; index < localVariableTypeInfoCount; ++index) {
            localVariableTypeInfos[index] = null;
        }
        return newIndex;
    }
}

