/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.RenamedDataEntry;

public class DataEntryObfuscator
implements DataEntryReader {
    private final ClassPool classPool;
    private final Map packagePrefixMap;
    private final DataEntryReader dataEntryReader;

    public DataEntryObfuscator(ClassPool classPool, Map packagePrefixMap, DataEntryReader dataEntryReader) {
        this.classPool = classPool;
        this.packagePrefixMap = packagePrefixMap;
        this.dataEntryReader = dataEntryReader;
    }

    public void read(DataEntry dataEntry) throws IOException {
        this.dataEntryReader.read(this.renamedDataEntry(dataEntry));
    }

    private DataEntry renamedDataEntry(DataEntry dataEntry) {
        String packagePrefix;
        String newPackagePrefix;
        String dataEntryName = dataEntry.getName();
        for (int suffixIndex = dataEntryName.length() - 1; suffixIndex > 0; --suffixIndex) {
            char c = dataEntryName.charAt(suffixIndex);
            if (Character.isLetterOrDigit(c)) continue;
            String className = dataEntryName.substring(0, suffixIndex);
            if (c == '/') break;
            Clazz clazz = this.classPool.getClass(className);
            if (clazz == null) continue;
            String newClassName = clazz.getName();
            if (className.equals(newClassName)) break;
            String newDataEntryName = newClassName + dataEntryName.substring(suffixIndex);
            return new RenamedDataEntry(dataEntry, newDataEntryName);
        }
        if ((newPackagePrefix = (String)this.packagePrefixMap.get(packagePrefix = ClassUtil.internalPackagePrefix(dataEntryName))) != null && !packagePrefix.equals(newPackagePrefix)) {
            String newDataEntryName = newPackagePrefix + dataEntryName.substring(packagePrefix.length());
            return new RenamedDataEntry(dataEntry, newDataEntryName);
        }
        return dataEntry;
    }
}

