/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import java.io.IOException;
import java.util.ArrayList;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.editor.MethodInvocationFixer;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.editor.VariableCleaner;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassForNameClassVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.DotClassClassVisitor;
import proguard.classfile.visitor.ExceptionCounter;
import proguard.classfile.visitor.ExceptionHandlerConstantVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.evaluation.value.IdentifiedValueFactory;
import proguard.optimize.ConstantMemberFilter;
import proguard.optimize.ConstantParameterFilter;
import proguard.optimize.DuplicateInitializerFixer;
import proguard.optimize.DuplicateInitializerInvocationFixer;
import proguard.optimize.KeepMarker;
import proguard.optimize.MethodDescriptorShrinker;
import proguard.optimize.MethodStaticizer;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.ParameterShrinker;
import proguard.optimize.TailRecursionSimplifier;
import proguard.optimize.WriteOnlyFieldFilter;
import proguard.optimize.evaluation.EvaluationShrinker;
import proguard.optimize.evaluation.EvaluationSimplifier;
import proguard.optimize.evaluation.LoadingInvocationUnit;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.StoringInvocationUnit;
import proguard.optimize.evaluation.VariableOptimizer;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.CaughtClassMarker;
import proguard.optimize.info.ClassOptimizationInfoSetter;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.InstanceofClassMarker;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.MemberOptimizationInfoSetter;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.NonPrivateMemberMarker;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.SideEffectMethodMarker;
import proguard.optimize.info.SuperInvocationMarker;
import proguard.optimize.peephole.BranchTargetFinder;
import proguard.optimize.peephole.ClassFinalizer;
import proguard.optimize.peephole.GotoCommonCodeReplacer;
import proguard.optimize.peephole.GotoGotoReplacer;
import proguard.optimize.peephole.GotoReturnReplacer;
import proguard.optimize.peephole.HorizontalClassMerger;
import proguard.optimize.peephole.InstructionSequenceConstants;
import proguard.optimize.peephole.InstructionSequencesReplacer;
import proguard.optimize.peephole.MemberPrivatizer;
import proguard.optimize.peephole.MethodFinalizer;
import proguard.optimize.peephole.MethodInliner;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.optimize.peephole.RetargetedInnerClassAttributeRemover;
import proguard.optimize.peephole.TargetClassChanger;
import proguard.optimize.peephole.UnreachableCodeRemover;
import proguard.optimize.peephole.UnreachableExceptionRemover;
import proguard.optimize.peephole.VariableShrinker;
import proguard.optimize.peephole.VerticalClassMerger;
import proguard.util.ConstantMatcher;
import proguard.util.ListParser;
import proguard.util.NameParser;

public class Optimizer {
    private static final String CLASS_MARKING_FINAL = "class/marking/final";
    private static final String CLASS_MERGING_VERTICAL = "class/merging/vertical";
    private static final String CLASS_MERGING_HORIZONTAL = "class/merging/horizontal";
    private static final String FIELD_REMOVAL_WRITEONLY = "field/removal/writeonly";
    private static final String FIELD_MARKING_PRIVATE = "field/marking/private";
    private static final String FIELD_PROPAGATION_VALUE = "field/propagation/value";
    private static final String METHOD_MARKING_PRIVATE = "method/marking/private";
    private static final String METHOD_MARKING_STATIC = "method/marking/static";
    private static final String METHOD_MARKING_FINAL = "method/marking/final";
    private static final String METHOD_REMOVAL_PARAMETER = "method/removal/parameter";
    private static final String METHOD_PROPAGATION_PARAMETER = "method/propagation/parameter";
    private static final String METHOD_PROPAGATION_RETURNVALUE = "method/propagation/returnvalue";
    private static final String METHOD_INLINING_SHORT = "method/inlining/short";
    private static final String METHOD_INLINING_UNIQUE = "method/inlining/unique";
    private static final String METHOD_INLINING_TAILRECURSION = "method/inlining/tailrecursion";
    private static final String CODE_MERGING = "code/merging";
    private static final String CODE_SIMPLIFICATION_VARIABLE = "code/simplification/variable";
    private static final String CODE_SIMPLIFICATION_ARITHMETIC = "code/simplification/arithmetic";
    private static final String CODE_SIMPLIFICATION_CAST = "code/simplification/cast";
    private static final String CODE_SIMPLIFICATION_FIELD = "code/simplification/field";
    private static final String CODE_SIMPLIFICATION_BRANCH = "code/simplification/branch";
    private static final String CODE_SIMPLIFICATION_ADVANCED = "code/simplification/advanced";
    private static final String CODE_REMOVAL_ADVANCED = "code/removal/advanced";
    private static final String CODE_REMOVAL_SIMPLE = "code/removal/simple";
    private static final String CODE_REMOVAL_VARIABLE = "code/removal/variable";
    private static final String CODE_REMOVAL_EXCEPTION = "code/removal/exception";
    private static final String CODE_ALLOCATION_VARIABLE = "code/allocation/variable";
    public static final String[] OPTIMIZATION_NAMES = new String[]{"class/marking/final", "class/merging/vertical", "class/merging/horizontal", "field/removal/writeonly", "field/propagation/value", "method/marking/private", "method/marking/static", "method/marking/final", "method/removal/parameter", "method/propagation/parameter", "method/propagation/returnvalue", "method/inlining/short", "method/inlining/unique", "method/inlining/tailrecursion", "code/merging", "code/simplification/variable", "code/simplification/arithmetic", "code/simplification/cast", "code/simplification/field", "code/simplification/branch", "code/simplification/advanced", "code/removal/advanced", "code/removal/simple", "code/removal/variable", "code/removal/exception", "code/allocation/variable"};
    private final Configuration configuration;

    public Optimizer(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean execute(ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        if (this.configuration.keep == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the optimization step.");
        }
        ConstantMatcher filter = this.configuration.optimizations != null ? new ListParser(new NameParser()).parse(this.configuration.optimizations) : new ConstantMatcher(true);
        boolean classMarkingFinal = filter.matches(CLASS_MARKING_FINAL);
        boolean classMergingVertical = filter.matches(CLASS_MERGING_VERTICAL);
        boolean classMergingHorizontal = filter.matches(CLASS_MERGING_HORIZONTAL);
        boolean fieldRemovalWriteonly = filter.matches(FIELD_REMOVAL_WRITEONLY);
        boolean fieldMarkingPrivate = filter.matches(FIELD_MARKING_PRIVATE);
        boolean fieldPropagationValue = filter.matches(FIELD_PROPAGATION_VALUE);
        boolean methodMarkingPrivate = filter.matches(METHOD_MARKING_PRIVATE);
        boolean methodMarkingStatic = filter.matches(METHOD_MARKING_STATIC);
        boolean methodMarkingFinal = filter.matches(METHOD_MARKING_FINAL);
        boolean methodRemovalParameter = filter.matches(METHOD_REMOVAL_PARAMETER);
        boolean methodPropagationParameter = filter.matches(METHOD_PROPAGATION_PARAMETER);
        boolean methodPropagationReturnvalue = filter.matches(METHOD_PROPAGATION_RETURNVALUE);
        boolean methodInliningShort = filter.matches(METHOD_INLINING_SHORT);
        boolean methodInliningUnique = filter.matches(METHOD_INLINING_UNIQUE);
        boolean methodInliningTailrecursion = filter.matches(METHOD_INLINING_TAILRECURSION);
        boolean codeMerging = filter.matches(CODE_MERGING);
        boolean codeSimplificationVariable = filter.matches(CODE_SIMPLIFICATION_VARIABLE);
        boolean codeSimplificationArithmetic = filter.matches(CODE_SIMPLIFICATION_ARITHMETIC);
        boolean codeSimplificationCast = filter.matches(CODE_SIMPLIFICATION_CAST);
        boolean codeSimplificationField = filter.matches(CODE_SIMPLIFICATION_FIELD);
        boolean codeSimplificationBranch = filter.matches(CODE_SIMPLIFICATION_BRANCH);
        boolean codeSimplificationAdvanced = filter.matches(CODE_SIMPLIFICATION_ADVANCED);
        boolean codeRemovalAdvanced = filter.matches(CODE_REMOVAL_ADVANCED);
        boolean codeRemovalSimple = filter.matches(CODE_REMOVAL_SIMPLE);
        boolean codeRemovalVariable = filter.matches(CODE_REMOVAL_VARIABLE);
        boolean codeRemovalException = filter.matches(CODE_REMOVAL_EXCEPTION);
        boolean codeAllocationVariable = filter.matches(CODE_ALLOCATION_VARIABLE);
        ClassCounter classMarkingFinalCounter = new ClassCounter();
        ClassCounter classMergingVerticalCounter = new ClassCounter();
        ClassCounter classMergingHorizontalCounter = new ClassCounter();
        MemberCounter fieldRemovalWriteonlyCounter = new MemberCounter();
        MemberCounter fieldMarkingPrivateCounter = new MemberCounter();
        MemberCounter fieldPropagationValueCounter = new MemberCounter();
        MemberCounter methodMarkingPrivateCounter = new MemberCounter();
        MemberCounter methodMarkingStaticCounter = new MemberCounter();
        MemberCounter methodMarkingFinalCounter = new MemberCounter();
        MemberCounter methodRemovalParameterCounter = new MemberCounter();
        MemberCounter methodPropagationParameterCounter = new MemberCounter();
        MemberCounter methodPropagationReturnvalueCounter = new MemberCounter();
        InstructionCounter methodInliningShortCounter = new InstructionCounter();
        InstructionCounter methodInliningUniqueCounter = new InstructionCounter();
        InstructionCounter methodInliningTailrecursionCounter = new InstructionCounter();
        InstructionCounter codeMergingCounter = new InstructionCounter();
        InstructionCounter codeSimplificationVariableCounter = new InstructionCounter();
        InstructionCounter codeSimplificationArithmeticCounter = new InstructionCounter();
        InstructionCounter codeSimplificationCastCounter = new InstructionCounter();
        InstructionCounter codeSimplificationFieldCounter = new InstructionCounter();
        InstructionCounter codeSimplificationBranchCounter = new InstructionCounter();
        InstructionCounter codeSimplificationAdvancedCounter = new InstructionCounter();
        InstructionCounter deletedCounter = new InstructionCounter();
        InstructionCounter addedCounter = new InstructionCounter();
        MemberCounter codeRemovalVariableCounter = new MemberCounter();
        ExceptionCounter codeRemovalExceptionCounter = new ExceptionCounter();
        MemberCounter codeAllocationVariableCounter = new MemberCounter();
        MemberCounter initializerFixCounter = new MemberCounter();
        codeSimplificationAdvanced = codeSimplificationAdvanced || fieldPropagationValue || methodPropagationParameter || methodPropagationReturnvalue;
        codeRemovalAdvanced = codeRemovalAdvanced || fieldRemovalWriteonly || methodMarkingStatic || methodRemovalParameter;
        codeRemovalSimple = codeRemovalSimple || codeSimplificationBranch;
        codeRemovalException = codeRemovalException || codeRemovalAdvanced || codeRemovalSimple;
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        programClassPool.classesAccept(new BottomClassFilter(new MethodLinker()));
        libraryClassPool.classesAccept(new BottomClassFilter(new MethodLinker()));
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolvisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, keepMarker, keepMarker, false, true, false);
        programClassPool.accept(classPoolvisitor);
        libraryClassPool.accept(classPoolvisitor);
        libraryClassPool.classesAccept(keepMarker);
        libraryClassPool.classesAccept(new AllMemberVisitor(keepMarker));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DotClassClassVisitor(keepMarker)))));
        programClassPool.classesAccept(new AllConstantVisitor(new ClassForNameClassVisitor(keepMarker)));
        programClassPool.classesAccept(new ClassOptimizationInfoSetter());
        programClassPool.classesAccept(new AllMemberVisitor(new MemberOptimizationInfoSetter()));
        if (this.configuration.assumeNoSideEffects != null) {
            NoSideEffectMethodMarker noSideEffectMethodMarker = new NoSideEffectMethodMarker();
            ClassPoolVisitor noClassPoolvisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.assumeNoSideEffects, null, (MemberVisitor)noSideEffectMethodMarker);
            programClassPool.accept(noClassPoolvisitor);
            libraryClassPool.accept(noClassPoolvisitor);
        }
        if (classMarkingFinal) {
            programClassPool.classesAccept(new ClassFinalizer(classMarkingFinalCounter));
        }
        if (methodMarkingFinal) {
            programClassPool.classesAccept(new AllMethodVisitor(new MethodFinalizer(methodMarkingFinalCounter)));
        }
        if (fieldRemovalWriteonly) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new ReadWriteFieldMarker()))));
            programClassPool.classesAccept(new AllFieldVisitor(new WriteOnlyFieldFilter(fieldRemovalWriteonlyCounter)));
        } else {
            programClassPool.classesAccept(new AllFieldVisitor(new ReadWriteFieldMarker()));
        }
        programClassPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new ParameterUsageMarker(!methodMarkingStatic, !methodRemovalParameter))));
        programClassPool.accept(new SideEffectMethodMarker());
        IdentifiedValueFactory valueFactory = new IdentifiedValueFactory();
        if (fieldPropagationValue || methodPropagationParameter || methodPropagationReturnvalue) {
            StoringInvocationUnit storingInvocationUnit = new StoringInvocationUnit(valueFactory, fieldPropagationValue, methodPropagationParameter, methodPropagationReturnvalue);
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PartialEvaluator(valueFactory, storingInvocationUnit, false))));
            programClassPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new AllFieldVisitor(new ConstantMemberFilter(fieldPropagationValueCounter)), new AllMethodVisitor(new ConstantParameterFilter(methodPropagationParameterCounter)), new AllMethodVisitor(new ConstantMemberFilter(methodPropagationReturnvalueCounter))}));
        }
        LoadingInvocationUnit loadingInvocationUnit = new LoadingInvocationUnit(valueFactory, fieldPropagationValue, methodPropagationParameter, methodPropagationReturnvalue);
        if (codeSimplificationAdvanced) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new EvaluationSimplifier(new PartialEvaluator(valueFactory, loadingInvocationUnit, false), codeSimplificationAdvancedCounter))));
        }
        if (codeRemovalAdvanced) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new EvaluationShrinker(new PartialEvaluator(valueFactory, loadingInvocationUnit, !codeSimplificationAdvanced), deletedCounter, addedCounter))));
        }
        if (methodRemovalParameter) {
            programClassPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MethodDescriptorShrinker())));
        }
        if (methodMarkingStatic) {
            programClassPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MemberAccessFilter(0, 8, new MethodStaticizer(methodMarkingStaticCounter)))));
        }
        if (methodRemovalParameter) {
            programClassPool.classesAccept(new MemberReferenceFixer());
        }
        if (methodRemovalParameter || methodMarkingPrivate || methodMarkingStatic) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new ParameterShrinker(methodRemovalParameterCounter))));
        } else if (codeRemovalAdvanced) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new StackSizeUpdater())));
        }
        programClassPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new AllConstantVisitor(new PackageVisibleMemberInvokingClassMarker()), new AllMethodVisitor(new MultiMemberVisitor(new MemberVisitor[]{new PackageVisibleMemberContainingClassMarker(), new AllAttributeVisitor(new MultiAttributeVisitor(new AttributeVisitor[]{new CatchExceptionMarker(), new AllInstructionVisitor(new MultiInstructionVisitor(new InstructionVisitor[]{new InstantiationClassMarker(), new InstanceofClassMarker(), new DotClassMarker(), new MethodInvocationMarker(), new SuperInvocationMarker(), new BackwardBranchMarker(), new AccessMethodMarker()})), new AllExceptionInfoVisitor(new ExceptionHandlerConstantVisitor(new ReferencedClassVisitor(new CaughtClassMarker())))}))}))}));
        if (classMergingVertical) {
            programClassPool.classesAccept(new VerticalClassMerger(this.configuration.allowAccessModification, this.configuration.mergeInterfacesAggressively, classMergingVerticalCounter));
        }
        if (classMergingHorizontal) {
            programClassPool.classesAccept(new HorizontalClassMerger(this.configuration.allowAccessModification, this.configuration.mergeInterfacesAggressively, classMergingHorizontalCounter));
        }
        if (classMergingVertical || classMergingHorizontal) {
            programClassPool.classesAccept(new RetargetedInnerClassAttributeRemover());
            programClassPool.classesAccept(new TargetClassChanger());
            programClassPool.classesAccept(new ClassReferenceFixer(true));
            programClassPool.classesAccept(new MemberReferenceFixer());
            if (this.configuration.allowAccessModification) {
                programClassPool.classesAccept(new AllConstantVisitor(new AccessFixer()));
            }
        }
        if (methodRemovalParameter || classMergingVertical || classMergingHorizontal) {
            programClassPool.classesAccept(new AllMethodVisitor(new DuplicateInitializerFixer(initializerFixCounter)));
            if (initializerFixCounter.getCount() > 0) {
                programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new DuplicateInitializerInvocationFixer(addedCounter))));
                programClassPool.classesAccept(new MemberReferenceFixer());
            }
        }
        if (methodInliningUnique) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new MethodInliner(this.configuration.microEdition, this.configuration.allowAccessModification, true, methodInliningUniqueCounter))));
        }
        if (methodInliningShort) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new MethodInliner(this.configuration.microEdition, this.configuration.allowAccessModification, false, methodInliningShortCounter))));
        }
        if (methodInliningTailrecursion) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new TailRecursionSimplifier(methodInliningTailrecursionCounter))));
        }
        if (fieldMarkingPrivate || methodMarkingPrivate) {
            programClassPool.classesAccept(new NonPrivateMemberMarker());
        }
        if (fieldMarkingPrivate || methodMarkingPrivate) {
            programClassPool.classesAccept(new AllFieldVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(fieldMarkingPrivateCounter))));
        }
        if (methodMarkingPrivate) {
            programClassPool.classesAccept(new ClassAccessFilter(0, 512, new AllMethodVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(methodMarkingPrivateCounter)))));
        }
        if ((methodInliningUnique || methodInliningShort || methodInliningTailrecursion) && this.configuration.allowAccessModification) {
            programClassPool.classesAccept(new AllConstantVisitor(new AccessFixer()));
        }
        if (methodRemovalParameter || classMergingVertical || classMergingHorizontal || methodMarkingPrivate) {
            programClassPool.classesAccept(new AllMemberVisitor(new AllAttributeVisitor(new MethodInvocationFixer())));
        }
        if (codeMerging) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new GotoCommonCodeReplacer(codeMergingCounter))));
        }
        BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        ArrayList<InstructionVisitor> peepholeOptimizations = new ArrayList<InstructionVisitor>();
        if (codeSimplificationVariable) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(InstructionSequenceConstants.CONSTANTS, InstructionSequenceConstants.VARIABLE, branchTargetFinder, codeAttributeEditor, codeSimplificationVariableCounter));
        }
        if (codeSimplificationArithmetic) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(InstructionSequenceConstants.CONSTANTS, InstructionSequenceConstants.ARITHMETIC, branchTargetFinder, codeAttributeEditor, codeSimplificationArithmeticCounter));
        }
        if (codeSimplificationCast) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(InstructionSequenceConstants.CONSTANTS, InstructionSequenceConstants.CAST, branchTargetFinder, codeAttributeEditor, codeSimplificationCastCounter));
        }
        if (codeSimplificationField) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(InstructionSequenceConstants.CONSTANTS, InstructionSequenceConstants.FIELD, branchTargetFinder, codeAttributeEditor, codeSimplificationFieldCounter));
        }
        if (codeSimplificationBranch) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(InstructionSequenceConstants.CONSTANTS, InstructionSequenceConstants.BRANCH, branchTargetFinder, codeAttributeEditor, codeSimplificationBranchCounter));
            peepholeOptimizations.add(new GotoGotoReplacer(codeAttributeEditor, codeSimplificationBranchCounter));
            peepholeOptimizations.add(new GotoReturnReplacer(codeAttributeEditor, codeSimplificationBranchCounter));
        }
        if (!peepholeOptimizations.isEmpty()) {
            InstructionVisitor[] peepholeOptimizationsArray = new InstructionVisitor[peepholeOptimizations.size()];
            peepholeOptimizations.toArray(peepholeOptimizationsArray);
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer(branchTargetFinder, codeAttributeEditor, new MultiInstructionVisitor(peepholeOptimizationsArray)))));
        }
        if (codeRemovalException) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new UnreachableExceptionRemover(codeRemovalExceptionCounter))));
        }
        if (codeRemovalSimple) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new UnreachableCodeRemover(deletedCounter))));
        }
        if (codeRemovalVariable) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new VariableShrinker(codeRemovalVariableCounter))));
        } else {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new VariableCleaner())));
        }
        if (codeAllocationVariable) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new VariableOptimizer(false, codeAllocationVariableCounter))));
        }
        int classMarkingFinalCount = classMarkingFinalCounter.getCount();
        int classMergingVerticalCount = classMergingVerticalCounter.getCount();
        int classMergingHorizontalCount = classMergingHorizontalCounter.getCount();
        int fieldRemovalWriteonlyCount = fieldRemovalWriteonlyCounter.getCount();
        int fieldMarkingPrivateCount = fieldMarkingPrivateCounter.getCount();
        int fieldPropagationValueCount = fieldPropagationValueCounter.getCount();
        int methodMarkingPrivateCount = methodMarkingPrivateCounter.getCount();
        int methodMarkingStaticCount = methodMarkingStaticCounter.getCount();
        int methodMarkingFinalCount = methodMarkingFinalCounter.getCount();
        int methodRemovalParameterCount = methodRemovalParameterCounter.getCount() - methodMarkingStaticCounter.getCount() - initializerFixCounter.getCount();
        int methodPropagationParameterCount = methodPropagationParameterCounter.getCount();
        int methodPropagationReturnvalueCount = methodPropagationReturnvalueCounter.getCount();
        int methodInliningShortCount = methodInliningShortCounter.getCount();
        int methodInliningUniqueCount = methodInliningUniqueCounter.getCount();
        int methodInliningTailrecursionCount = methodInliningTailrecursionCounter.getCount();
        int codeMergingCount = codeMergingCounter.getCount();
        int codeSimplificationVariableCount = codeSimplificationVariableCounter.getCount();
        int codeSimplificationArithmeticCount = codeSimplificationArithmeticCounter.getCount();
        int codeSimplificationCastCount = codeSimplificationCastCounter.getCount();
        int codeSimplificationFieldCount = codeSimplificationFieldCounter.getCount();
        int codeSimplificationBranchCount = codeSimplificationBranchCounter.getCount();
        int codeSimplificationAdvancedCount = codeSimplificationAdvancedCounter.getCount();
        int codeRemovalCount = deletedCounter.getCount() - addedCounter.getCount();
        int codeRemovalVariableCount = codeRemovalVariableCounter.getCount();
        int codeRemovalExceptionCount = codeRemovalExceptionCounter.getCount();
        int codeAllocationVariableCount = codeAllocationVariableCounter.getCount();
        if (this.configuration.verbose) {
            System.out.println("  Number of finalized classes:                 " + classMarkingFinalCount + this.disabled(classMarkingFinal));
            System.out.println("  Number of vertically merged classes:         " + classMergingVerticalCount + this.disabled(classMergingVertical));
            System.out.println("  Number of horizontally merged classes:       " + classMergingHorizontalCount + this.disabled(classMergingHorizontal));
            System.out.println("  Number of removed write-only fields:         " + fieldRemovalWriteonlyCount + this.disabled(fieldRemovalWriteonly));
            System.out.println("  Number of privatized fields:                 " + fieldMarkingPrivateCount + this.disabled(fieldMarkingPrivate));
            System.out.println("  Number of inlined constant fields:           " + fieldPropagationValueCount + this.disabled(fieldPropagationValue));
            System.out.println("  Number of privatized methods:                " + methodMarkingPrivateCount + this.disabled(methodMarkingPrivate));
            System.out.println("  Number of staticized methods:                " + methodMarkingStaticCount + this.disabled(methodMarkingStatic));
            System.out.println("  Number of finalized methods:                 " + methodMarkingFinalCount + this.disabled(methodMarkingFinal));
            System.out.println("  Number of removed method parameters:         " + methodRemovalParameterCount + this.disabled(methodRemovalParameter));
            System.out.println("  Number of inlined constant parameters:       " + methodPropagationParameterCount + this.disabled(methodPropagationParameter));
            System.out.println("  Number of inlined constant return values:    " + methodPropagationReturnvalueCount + this.disabled(methodPropagationReturnvalue));
            System.out.println("  Number of inlined short method calls:        " + methodInliningShortCount + this.disabled(methodInliningShort));
            System.out.println("  Number of inlined unique method calls:       " + methodInliningUniqueCount + this.disabled(methodInliningUnique));
            System.out.println("  Number of inlined tail recursion calls:      " + methodInliningTailrecursionCount + this.disabled(methodInliningTailrecursion));
            System.out.println("  Number of merged code blocks:                " + codeMergingCount + this.disabled(codeMerging));
            System.out.println("  Number of variable peephole optimizations:   " + codeSimplificationVariableCount + this.disabled(codeSimplificationVariable));
            System.out.println("  Number of arithmetic peephole optimizations: " + codeSimplificationArithmeticCount + this.disabled(codeSimplificationArithmetic));
            System.out.println("  Number of cast peephole optimizations:       " + codeSimplificationCastCount + this.disabled(codeSimplificationCast));
            System.out.println("  Number of field peephole optimizations:      " + codeSimplificationFieldCount + this.disabled(codeSimplificationField));
            System.out.println("  Number of branch peephole optimizations:     " + codeSimplificationBranchCount + this.disabled(codeSimplificationBranch));
            System.out.println("  Number of simplified instructions:           " + codeSimplificationAdvancedCount + this.disabled(codeSimplificationAdvanced));
            System.out.println("  Number of removed instructions:              " + codeRemovalCount + this.disabled(codeRemovalAdvanced));
            System.out.println("  Number of removed local variables:           " + codeRemovalVariableCount + this.disabled(codeRemovalVariable));
            System.out.println("  Number of removed exception blocks:          " + codeRemovalExceptionCount + this.disabled(codeRemovalException));
            System.out.println("  Number of optimized local variable frames:   " + codeAllocationVariableCount + this.disabled(codeAllocationVariable));
        }
        return classMarkingFinalCount > 0 || classMergingVerticalCount > 0 || classMergingHorizontalCount > 0 || fieldRemovalWriteonlyCount > 0 || fieldMarkingPrivateCount > 0 || methodMarkingPrivateCount > 0 || methodMarkingStaticCount > 0 || methodMarkingFinalCount > 0 || fieldPropagationValueCount > 0 || methodRemovalParameterCount > 0 || methodPropagationParameterCount > 0 || methodPropagationReturnvalueCount > 0 || methodInliningShortCount > 0 || methodInliningUniqueCount > 0 || methodInliningTailrecursionCount > 0 || codeMergingCount > 0 || codeSimplificationVariableCount > 0 || codeSimplificationArithmeticCount > 0 || codeSimplificationCastCount > 0 || codeSimplificationFieldCount > 0 || codeSimplificationBranchCount > 0 || codeSimplificationAdvancedCount > 0 || codeRemovalCount > 0 || codeRemovalVariableCount > 0 || codeRemovalExceptionCount > 0 || codeAllocationVariableCount > 0;
    }

    private String disabled(boolean flag) {
        return flag ? "" : "   (disabled)";
    }

    private String disabled(boolean flag1, boolean flag2) {
        return flag1 && flag2 ? "" : (flag1 || flag2 ? "   (partially disabled)" : "   (disabled)");
    }
}

