/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class BranchInstruction
extends Instruction {
    public int branchOffset;

    public BranchInstruction() {
    }

    public BranchInstruction(byte opcode, int branchOffset) {
        this.opcode = opcode;
        this.branchOffset = branchOffset;
    }

    public BranchInstruction copy(BranchInstruction branchInstruction) {
        this.opcode = branchInstruction.opcode;
        this.branchOffset = branchInstruction.branchOffset;
        return this;
    }

    public byte canonicalOpcode() {
        switch (this.opcode) {
            case -56: {
                return -89;
            }
            case -55: {
                return -88;
            }
        }
        return this.opcode;
    }

    public Instruction shrink() {
        if (this.requiredBranchOffsetSize() == 2) {
            if (this.opcode == -56) {
                this.opcode = (byte)-89;
            } else if (this.opcode == -55) {
                this.opcode = (byte)-88;
            }
        } else if (this.opcode == -89 || this.opcode == -56) {
            this.opcode = (byte)-56;
        } else if (this.opcode == -88) {
            this.opcode = (byte)-55;
        } else {
            throw new IllegalArgumentException("Branch instruction can't be widened (" + this.toString() + ")");
        }
        return this;
    }

    protected void readInfo(byte[] code, int offset) {
        this.branchOffset = BranchInstruction.readSignedValue(code, offset, this.branchOffsetSize());
    }

    protected void writeInfo(byte[] code, int offset) {
        if (this.requiredBranchOffsetSize() > this.branchOffsetSize()) {
            throw new IllegalArgumentException("Instruction has invalid branch offset size (" + this.toString(offset) + ")");
        }
        BranchInstruction.writeSignedValue(code, offset, this.branchOffset, this.branchOffsetSize());
    }

    public int length(int offset) {
        return 1 + this.branchOffsetSize();
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, offset, this);
    }

    public String toString(int offset) {
        return "[" + offset + "] " + this.toString() + " (target=" + (offset + this.branchOffset) + ")";
    }

    public String toString() {
        return this.getName() + " " + (this.branchOffset >= 0 ? "+" : "") + this.branchOffset;
    }

    private int branchOffsetSize() {
        return this.opcode == -56 || this.opcode == -55 ? 4 : 2;
    }

    private int requiredBranchOffsetSize() {
        return (short)this.branchOffset == this.branchOffset ? 2 : 4;
    }
}

