/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberCollector
extends SimplifiedVisitor
implements MemberVisitor {
    private final boolean includeClassName;
    private final boolean includeMemberName;
    private final boolean includeMemberDescriptor;
    private final Set set;

    public MemberCollector(boolean includeClassName, boolean includeMemberName, boolean includeMemberDescriptor, Set set) {
        this.includeClassName = includeClassName;
        this.includeMemberName = includeMemberName;
        this.includeMemberDescriptor = includeMemberDescriptor;
        this.set = set;
    }

    public void visitAnyMember(Clazz clazz, Member member) {
        StringBuffer buffer = new StringBuffer();
        if (this.includeClassName) {
            buffer.append(clazz.getName()).append('.');
        }
        if (this.includeMemberName) {
            buffer.append(member.getName(clazz)).append('.');
        }
        if (this.includeMemberDescriptor) {
            buffer.append(member.getDescriptor(clazz));
        }
        this.set.add(buffer.toString());
    }
}

