/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;

public class ClassMapDataEntryWriter
extends SimplifiedVisitor
implements DataEntryWriter,
MemberVisitor {
    private final ClassPool programClassPool;
    private final DataEntryWriter dataEntryWriter;
    private boolean obfuscatedMethods = false;
    private boolean obfuscatedFields = false;

    public ClassMapDataEntryWriter(ClassPool programClassPool, DataEntryWriter dataEntryWriter) {
        this.programClassPool = programClassPool;
        this.dataEntryWriter = dataEntryWriter;
    }

    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(dataEntry);
    }

    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        OutputStream os = this.dataEntryWriter.createOutputStream(dataEntry);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(os));
        this.writeClassMap(writer, this.programClassPool);
        writer.close();
        return os;
    }

    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "ClassMapDataEntryWriter");
        this.dataEntryWriter.println(pw, prefix + "  ");
    }

    private void writeClassMap(PrintWriter writer, ClassPool classPool) {
        Iterator iterator = classPool.classNames();
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            StringBuilder builder = new StringBuilder();
            builder.append(ClassUtil.externalClassName(className));
            builder.append(",");
            ProgramClass clazz = (ProgramClass)classPool.getClass(className);
            builder.append(ClassUtil.externalClassName(clazz.getName()));
            builder.append(",");
            boolean hasRemovedMethods = (clazz.u2accessFlags & 0x20000) != 0;
            builder.append(hasRemovedMethods || this.hasObfuscatedMethods(clazz) ? 1 : 0);
            builder.append(",");
            boolean hasRemovedFields = (clazz.u2accessFlags & 0x40000) != 0;
            builder.append(hasRemovedFields || this.hasObfuscatedFields(clazz) ? 1 : 0);
            writer.println(builder.toString());
        }
    }

    private boolean hasObfuscatedMethods(ProgramClass clazz) {
        this.obfuscatedMethods = false;
        clazz.methodsAccept(this);
        return this.obfuscatedMethods;
    }

    private boolean hasObfuscatedFields(ProgramClass clazz) {
        this.obfuscatedFields = false;
        clazz.fieldsAccept(this);
        return this.obfuscatedFields;
    }

    public void visitAnyMember(Clazz clazz, Member member) {
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.obfuscatedMethods |= (programMethod.getAccessFlags() & 0x10000) != 0;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.obfuscatedFields |= (programField.getAccessFlags() & 0x10000) != 0;
    }
}

