/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import java.util.List;
import proguard.ClassSpecificationVisitorFactory;
import proguard.MemberSpecification;
import proguard.MemberValueSpecification;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MethodOptimizationInfo;

public class AssumeClassSpecificationVisitorFactory
extends ClassSpecificationVisitorFactory {
    private final ValueFactory valueFactory;

    public AssumeClassSpecificationVisitorFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    protected ClassVisitor createNonTestingClassVisitor(MemberSpecification memberSpecification, boolean isField, MemberVisitor memberVisitor, AttributeVisitor attributeVisitor, List variableStringMatchers) {
        if (memberSpecification instanceof MemberValueSpecification) {
            MemberValueSpecification memberValueSpecification = (MemberValueSpecification)memberSpecification;
            Number[] values = memberValueSpecification.values;
            if (values != null) {
                Value value = this.value(values);
                memberVisitor = new MultiMemberVisitor(memberVisitor, new OptimizationInfoMemberFilter(new MyMemberValueSetter(value)));
            }
        }
        return super.createNonTestingClassVisitor(memberSpecification, isField, memberVisitor, attributeVisitor, variableStringMatchers);
    }

    private Value value(Number[] values) {
        return values.length == 1 ? this.valueFactory.createIntegerValue(values[0].intValue()) : this.valueFactory.createIntegerValue(values[0].intValue(), values[1].intValue());
    }

    private static class MyMemberValueSetter
    implements MemberVisitor {
        private final Value value;

        public MyMemberValueSetter(Value value) {
            this.value = value;
        }

        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            FieldOptimizationInfo.getFieldOptimizationInfo(programField).setValue(this.value);
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            MethodOptimizationInfo.getMethodOptimizationInfo(programMethod).setReturnValue(this.value);
        }

        public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
            FieldOptimizationInfo.getFieldOptimizationInfo(libraryField).setValue(this.value);
        }

        public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
            MethodOptimizationInfo.getMethodOptimizationInfo(libraryMethod).setReturnValue(this.value);
        }
    }
}

