/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.classfile.Clazz;
import proguard.evaluation.value.ArrayReferenceValue;
import proguard.evaluation.value.DetailedArrayReferenceValue;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IdentifiedArrayReferenceValue;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.UnknownReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;

public class TracedReferenceValue
extends ReferenceValue {
    private final ReferenceValue referenceValue;
    private final Value traceValue;

    public TracedReferenceValue(ReferenceValue referenceValue, Value traceValue) {
        this.referenceValue = referenceValue;
        this.traceValue = traceValue;
    }

    public ReferenceValue getReferenceValue() {
        return this.referenceValue;
    }

    public Value getTraceValue() {
        return this.traceValue;
    }

    public String getType() {
        return this.referenceValue.getType();
    }

    public Clazz getReferencedClass() {
        return this.referenceValue.getReferencedClass();
    }

    public boolean mayBeExtension() {
        return this.referenceValue.mayBeExtension();
    }

    public int isNull() {
        return this.referenceValue.isNull();
    }

    public int instanceOf(String otherType, Clazz otherReferencedClass) {
        return this.referenceValue.instanceOf(otherType, otherReferencedClass);
    }

    public ReferenceValue cast(String type, Clazz referencedClass, ValueFactory valueFactory, boolean alwaysCast) {
        return ((ReferenceTracingValueFactory)valueFactory).cast(this, type, referencedClass, alwaysCast);
    }

    public IntegerValue arrayLength(ValueFactory valueFactory) {
        return this.referenceValue.arrayLength(valueFactory);
    }

    public IntegerValue integerArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        return this.referenceValue.integerArrayLoad(indexValue, valueFactory);
    }

    public LongValue longArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        return this.referenceValue.longArrayLoad(indexValue, valueFactory);
    }

    public FloatValue floatArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        return this.referenceValue.floatArrayLoad(indexValue, valueFactory);
    }

    public DoubleValue doubleArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        return this.referenceValue.doubleArrayLoad(indexValue, valueFactory);
    }

    public ReferenceValue referenceArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        ReferenceValue value = this.referenceValue.referenceArrayLoad(indexValue, valueFactory);
        return value instanceof TracedReferenceValue ? value : ((ReferenceTracingValueFactory)valueFactory).trace(value);
    }

    public void arrayStore(IntegerValue indexValue, Value value) {
        this.referenceValue.arrayStore(indexValue, value);
    }

    public ReferenceValue generalize(ReferenceValue other) {
        return other.generalize(this);
    }

    public int equal(ReferenceValue other) {
        return other.equal(this);
    }

    public ReferenceValue generalize(UnknownReferenceValue other) {
        return new TracedReferenceValue(this.referenceValue.generalize(other), this.traceValue);
    }

    public int equal(UnknownReferenceValue other) {
        return this.referenceValue.equal(other);
    }

    public ReferenceValue generalize(TypedReferenceValue other) {
        return new TracedReferenceValue(this.referenceValue.generalize(other), this.traceValue);
    }

    public int equal(TypedReferenceValue other) {
        return this.referenceValue.equal(other);
    }

    public ReferenceValue generalize(IdentifiedReferenceValue other) {
        return new TracedReferenceValue(this.referenceValue.generalize(other), this.traceValue);
    }

    public int equal(IdentifiedReferenceValue other) {
        return this.referenceValue.equal(other);
    }

    public ReferenceValue generalize(ArrayReferenceValue other) {
        return new TracedReferenceValue(this.referenceValue.generalize(other), this.traceValue);
    }

    public int equal(ArrayReferenceValue other) {
        return this.referenceValue.equal(other);
    }

    public ReferenceValue generalize(IdentifiedArrayReferenceValue other) {
        return new TracedReferenceValue(this.referenceValue.generalize(other), this.traceValue);
    }

    public int equal(IdentifiedArrayReferenceValue other) {
        return this.referenceValue.equal(other);
    }

    public ReferenceValue generalize(DetailedArrayReferenceValue other) {
        return new TracedReferenceValue(this.referenceValue.generalize(other), this.traceValue);
    }

    public int equal(DetailedArrayReferenceValue other) {
        return this.referenceValue.equal(other);
    }

    public ReferenceValue generalize(TracedReferenceValue other) {
        if (this.equals(other)) {
            return this;
        }
        return new TracedReferenceValue(this.referenceValue.generalize(other.referenceValue), this.traceValue.generalize(other.traceValue));
    }

    public int equal(TracedReferenceValue other) {
        return this.referenceValue.equal(other.referenceValue);
    }

    public boolean isSpecific() {
        return this.referenceValue.isSpecific();
    }

    public boolean isParticular() {
        return this.referenceValue.isParticular();
    }

    public String internalType() {
        return this.referenceValue.internalType();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TracedReferenceValue other = (TracedReferenceValue)object;
        return this.referenceValue.equals(other.referenceValue) && this.traceValue.equals(other.traceValue);
    }

    public int hashCode() {
        return this.referenceValue.hashCode() ^ this.traceValue.hashCode();
    }

    public String toString() {
        return this.traceValue.toString() + this.referenceValue.toString();
    }
}

