/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.SimpleNameFactory;

public class DictionaryNameFactory
implements NameFactory {
    private static final char COMMENT_CHARACTER = '#';
    private final List names;
    private final NameFactory nameFactory;
    private int index = 0;

    public DictionaryNameFactory(URL url, NameFactory nameFactory) throws IOException {
        this(url, true, nameFactory);
    }

    public DictionaryNameFactory(URL url, boolean validJavaIdentifiers, NameFactory nameFactory) throws IOException {
        this(new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8")), validJavaIdentifiers, nameFactory);
    }

    public DictionaryNameFactory(File file, NameFactory nameFactory) throws IOException {
        this(file, true, nameFactory);
    }

    public DictionaryNameFactory(File file, boolean validJavaIdentifiers, NameFactory nameFactory) throws IOException {
        this(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8")), validJavaIdentifiers, nameFactory);
    }

    public DictionaryNameFactory(Reader reader, NameFactory nameFactory) throws IOException {
        this(reader, true, nameFactory);
    }

    public DictionaryNameFactory(Reader reader, boolean validJavaIdentifiers, NameFactory nameFactory) throws IOException {
        this.names = new ArrayList();
        this.nameFactory = nameFactory;
        try {
            StringBuffer buffer = new StringBuffer();
            while (true) {
                int c;
                if ((c = reader.read()) != -1 && (validJavaIdentifiers ? (buffer.length() == 0 ? Character.isJavaIdentifierStart((char)c) : Character.isJavaIdentifierPart((char)c)) : c != 10 && c != 13 && c != 35)) {
                    buffer.append((char)c);
                    continue;
                }
                if (buffer.length() > 0) {
                    String name = buffer.toString();
                    if (!this.names.contains(name)) {
                        this.names.add(name);
                    }
                    buffer.setLength(0);
                }
                if (c == 35) {
                    while ((c = reader.read()) != -1 && c != 10 && c != 13) {
                    }
                }
                if (c != -1) continue;
                return;
            }
        }
        finally {
            reader.close();
        }
    }

    public DictionaryNameFactory(DictionaryNameFactory dictionaryNameFactory, NameFactory nameFactory) {
        this.names = dictionaryNameFactory.names;
        this.nameFactory = nameFactory;
    }

    public void reset() {
        this.index = 0;
        this.nameFactory.reset();
    }

    public String nextName() {
        String name;
        if (this.index < this.names.size()) {
            name = (String)this.names.get(this.index++);
        } else {
            while (this.names.contains(name = this.nameFactory.nextName())) {
            }
        }
        return name;
    }

    public static void main(String[] args) {
        try {
            DictionaryNameFactory factory = new DictionaryNameFactory(new File(args[0]), (NameFactory)new SimpleNameFactory());
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
            for (int counter = 0; counter < 50; ++counter) {
                out.println("[" + factory.nextName() + "]");
            }
            out.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

