/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class RenamedFlagSetter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    public void visitProgramClass(ProgramClass programClass) {
        String oldName = programClass.getName();
        String newName = ClassObfuscator.newClassName(programClass);
        if (newName != null && !oldName.equals(newName)) {
            programClass.u2accessFlags |= 0x10000;
        }
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        String oldName = programMember.getName(programClass);
        String newName = MemberObfuscator.newMemberName(programMember);
        if (newName != null && !newName.equals(oldName)) {
            programMember.u2accessFlags |= 0x10000;
        }
    }
}

