/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.SingleTimeAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.gson.TypeArgumentFinder;

public class GsonDeserializationInvocationFinder
extends SimplifiedVisitor
implements InstructionVisitor {
    public static boolean DEBUG = System.getProperty("gdif") != null;
    private final ClassPool programClassPool;
    private final ClassVisitor domainClassVisitor;
    private final WarningPrinter notePrinter;
    private final FromJsonInvocationMatcher[] fromJsonInvocationMatchers;
    private final TypedReferenceValueFactory valueFactory = new TypedReferenceValueFactory();
    private final PartialEvaluator partialEvaluator = new PartialEvaluator(this.valueFactory, new BasicInvocationUnit(new TypedReferenceValueFactory()), true);
    private final AttributeVisitor lazyPartialEvaluator = new AttributeNameFilter("Code", (AttributeVisitor)new SingleTimeAttributeVisitor(this.partialEvaluator));

    public GsonDeserializationInvocationFinder(ClassPool programClassPool, ClassVisitor domainClassVisitor, WarningPrinter notePrinter) {
        this.programClassPool = programClassPool;
        this.domainClassVisitor = domainClassVisitor;
        this.notePrinter = notePrinter;
        InstructionSequenceBuilder builder = new InstructionSequenceBuilder();
        Instruction[] fromJsonStringClassInstructions = builder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;").instructions();
        Instruction[] fromJsonStringTypeInstructions = builder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;").instructions();
        Instruction[] fromJsonReaderClassInstructions = builder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/io/Reader;Ljava/lang/Class;)Ljava/lang/Object;").instructions();
        Instruction[] fromJsonReaderTypeInstructions = builder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/io/Reader;Ljava/lang/reflect/Type;)Ljava/lang/Object;").instructions();
        Instruction[] fromJsonJsonReaderTypeInstructions = builder.invokevirtual("com/google/gson/Gson", "fromJson", "(Lcom/google/gson/stream/JsonReader;Ljava/lang/reflect/Type;)Ljava/lang/Object;").instructions();
        Constant[] constants = builder.constants();
        this.fromJsonInvocationMatchers = new FromJsonInvocationMatcher[]{new FromJsonInvocationMatcher(constants, fromJsonStringClassInstructions, 0, -1), new FromJsonInvocationMatcher(constants, fromJsonStringTypeInstructions, -1, 0), new FromJsonInvocationMatcher(constants, fromJsonReaderClassInstructions, 0, -1), new FromJsonInvocationMatcher(constants, fromJsonReaderTypeInstructions, -1, 0), new FromJsonInvocationMatcher(constants, fromJsonJsonReaderTypeInstructions, -1, 0)};
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        FromJsonInvocationMatcher matchingMatcher = null;
        for (FromJsonInvocationMatcher matcher : this.fromJsonInvocationMatchers) {
            instruction.accept(clazz, method, codeAttribute, offset, matcher);
            if (!matcher.isMatching()) continue;
            matchingMatcher = matcher;
            break;
        }
        if (matchingMatcher != null) {
            if (DEBUG) {
                System.out.println("GsonDeserializationInvocationFinder: Gson#fromJson: " + clazz.getName() + "." + method.getName(clazz) + method.getDescriptor(clazz) + " " + instruction.toString(offset));
            }
            this.lazyPartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
            int stackElementIndex = matchingMatcher.typeStackElementIndex == -1 ? matchingMatcher.classStackElementIndex : matchingMatcher.typeStackElementIndex;
            InstructionOffsetValue producer = this.partialEvaluator.getStackBefore(offset).getTopActualProducerValue(stackElementIndex).instructionOffsetValue();
            TypeArgumentFinder typeArgumentFinder = new TypeArgumentFinder(this.programClassPool, this.partialEvaluator);
            for (int i = 0; i < producer.instructionOffsetCount(); ++i) {
                codeAttribute.instructionAccept(clazz, method, producer.instructionOffset(i), typeArgumentFinder);
            }
            String[] targetTypes = typeArgumentFinder.typeArgumentClasses;
            if (targetTypes != null) {
                for (String targetType : targetTypes) {
                    Clazz targetClass = this.programClassPool.getClass(targetType);
                    if (targetClass == null) continue;
                    targetClass.accept(this.domainClassVisitor);
                }
            } else if (this.notePrinter != null) {
                this.notePrinter.print(clazz.getName(), "Note: can't derive deserialized type from fromJson() invocation in " + clazz.getName() + "." + method.getName(clazz) + method.getDescriptor(clazz));
            }
        }
    }

    private static class FromJsonInvocationMatcher
    extends InstructionSequenceMatcher {
        private int classStackElementIndex;
        private int typeStackElementIndex;

        private FromJsonInvocationMatcher(Constant[] patternConstants, Instruction[] patternInstructions, int classStackElementIndex, int typeStackElementIndex) {
            super(patternConstants, patternInstructions);
            this.classStackElementIndex = classStackElementIndex;
            this.typeStackElementIndex = typeStackElementIndex;
        }
    }
}

