/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AnnotationsAttributeEditor;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.ParameterAnnotationsAttributeEditor;
import proguard.classfile.util.SimplifiedVisitor;

public class MarkedAnnotationDeleter
extends SimplifiedVisitor
implements AttributeVisitor {
    private final Object mark;

    public MarkedAnnotationDeleter(Object mark) {
        this.mark = mark;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, runtimeVisibleAnnotationsAttribute, "RuntimeVisibleAnnotations");
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, runtimeInvisibleAnnotationsAttribute, "RuntimeInvisibleAnnotations");
    }

    public void visitRuntimeVisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute) {
        this.cleanParameterAnnotationsAttribute(clazz, runtimeVisibleParameterAnnotationsAttribute, "RuntimeVisibleParameterAnnotations");
    }

    public void visitRuntimeInvisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute) {
        this.cleanParameterAnnotationsAttribute(clazz, runtimeInvisibleParameterAnnotationsAttribute, "RuntimeInvisibleParameterAnnotations");
    }

    public void visitRuntimeVisibleTypeAnnotationsAttribute(Clazz clazz, RuntimeVisibleTypeAnnotationsAttribute runtimeVisibleTypeAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, runtimeVisibleTypeAnnotationsAttribute, "RuntimeVisibleParameterAnnotations");
    }

    public void visitRuntimeInvisibleTypeAnnotationsAttribute(Clazz clazz, RuntimeInvisibleTypeAnnotationsAttribute runtimeInvisibleTypeAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, runtimeInvisibleTypeAnnotationsAttribute, "RuntimeInvisibleParameterAnnotations");
    }

    private void cleanAnnotationsAttribute(Clazz clazz, AnnotationsAttribute attribute, String classConstant) {
        AnnotationsAttributeEditor annotationsAttributeEditor = new AnnotationsAttributeEditor(attribute);
        Annotation[] annotations = attribute.annotations;
        for (int index = 0; index < attribute.u2annotationsCount; ++index) {
            Annotation annotation = annotations[index];
            if (annotation.getVisitorInfo() != this.mark) continue;
            annotationsAttributeEditor.deleteAnnotation(index);
        }
        if (attribute.u2annotationsCount == 0) {
            AttributesEditor attributesEditor = new AttributesEditor((ProgramClass)clazz, false);
            attributesEditor.deleteAttribute(classConstant);
        }
    }

    private void cleanParameterAnnotationsAttribute(Clazz clazz, ParameterAnnotationsAttribute attribute, String classConstant) {
        ParameterAnnotationsAttributeEditor annotationsAttributeEditor = new ParameterAnnotationsAttributeEditor(attribute);
        boolean allEmpty = true;
        for (int parameterIndex = 0; parameterIndex < attribute.u1parametersCount; ++parameterIndex) {
            int annotationsCount = attribute.u2parameterAnnotationsCount[parameterIndex];
            Annotation[] annotations = attribute.parameterAnnotations[parameterIndex];
            for (int annotationIndex = 0; annotationIndex < annotationsCount; ++annotationIndex) {
                Annotation annotation = annotations[annotationIndex];
                if (annotation.getVisitorInfo() != this.mark) continue;
                annotationsAttributeEditor.deleteAnnotation(parameterIndex, annotationIndex);
            }
            if (attribute.u2parameterAnnotationsCount[parameterIndex] == 0) continue;
            allEmpty = false;
        }
        if (allEmpty) {
            AttributesEditor attributesEditor = new AttributesEditor((ProgramClass)clazz, false);
            attributesEditor.deleteAttribute(classConstant);
        }
    }
}

