/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.log4j;

import it.openutils.log4j.DefaultEvaluator;
import it.openutils.log4j.LoggingEventAggregator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class AlternateSMTPAppender
extends AppenderSkeleton {
    protected Map<LoggingEventAggregator, LoggingEventAggregator> events = new LinkedHashMap<LoggingEventAggregator, LoggingEventAggregator>(){
        private static final long serialVersionUID = 1L;

        @Override
        public LoggingEventAggregator put(LoggingEventAggregator key, LoggingEventAggregator value) {
            LoggingEventAggregator lea = (LoggingEventAggregator)this.get(key);
            if (lea != null) {
                lea.incrementCount();
                return lea;
            }
            return super.put(key, value);
        }
    };
    protected Message msg;
    protected TriggeringEventEvaluator evaluator;
    private String to;
    private String from;
    private Layout subjectLayout;
    private Layout headerLayout;
    private String smtpHost;
    private boolean locationInfo;
    private Timer timer = new Timer("log4j mail appender", true);
    private TimerTask timerTask;
    private int timeout;

    public AlternateSMTPAppender() {
        this(new DefaultEvaluator());
        MimeBodyPart.class.getName();
        MimeUtility.class.getName();
    }

    public AlternateSMTPAppender(TriggeringEventEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void activateOptions() {
        Properties props = new Properties(System.getProperties());
        if (this.smtpHost != null) {
            props.put("mail.smtp.host", this.smtpHost);
        }
        Session session = Session.getInstance((Properties)props, null);
        this.msg = new MimeMessage(session);
        try {
            if (this.from != null) {
                this.msg.setFrom((Address)this.getAddress(this.from));
            } else {
                this.msg.setFrom();
            }
            this.msg.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(this.to));
        }
        catch (MessagingException e) {
            LogLog.error((String)"Could not activate SMTPAppender options.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        event.getThreadName();
        event.getNDC();
        event.getMDCCopy();
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        LoggingEventAggregator leg = new LoggingEventAggregator(event);
        if (this.evaluator.isTriggeringEvent(event)) {
            if (this.timeout == 0) {
                Map<LoggingEventAggregator, LoggingEventAggregator> map = this.events;
                synchronized (map) {
                    ArrayList<LoggingEventAggregator> le = new ArrayList<LoggingEventAggregator>();
                    le.add(leg);
                    this.sendBuffer(le);
                }
            } else {
                this.events.put(leg, leg);
                if (this.timerTask == null) {
                    this.timerTask = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ArrayList<LoggingEventAggregator> le;
                            Map<LoggingEventAggregator, LoggingEventAggregator> map = AlternateSMTPAppender.this.events;
                            synchronized (map) {
                                le = new ArrayList<LoggingEventAggregator>(AlternateSMTPAppender.this.events.values());
                                AlternateSMTPAppender.this.events.clear();
                                AlternateSMTPAppender.this.timerTask = null;
                            }
                            AlternateSMTPAppender.this.sendBuffer(le);
                        }
                    };
                    this.timer.schedule(this.timerTask, (long)this.timeout * 1000L);
                }
            }
        }
    }

    protected boolean checkEntryConditions() {
        if (this.msg == null) {
            this.errorHandler.error("Message object not configured.");
            return false;
        }
        if (this.evaluator == null) {
            this.errorHandler.error("No TriggeringEventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        this.closed = true;
    }

    InternetAddress getAddress(String addressStr) {
        try {
            return new InternetAddress(addressStr);
        }
        catch (AddressException e) {
            this.errorHandler.error("Could not parse address [" + addressStr + "].", (Exception)((Object)e), 6);
            return null;
        }
    }

    InternetAddress[] parseAddress(String addressStr) {
        try {
            return InternetAddress.parse((String)addressStr, (boolean)true);
        }
        catch (AddressException e) {
            this.errorHandler.error("Could not parse address [" + addressStr + "].", (Exception)((Object)e), 6);
            return null;
        }
    }

    public String getTo() {
        return this.to;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void sendBuffer(Collection<LoggingEventAggregator> eventsCollection) {
        try {
            for (LoggingEventAggregator lea : eventsCollection) {
                String[] s;
                String t;
                MimeBodyPart part = new MimeBodyPart();
                StringBuilder sbuf = new StringBuilder();
                LoggingEvent event = lea.getLoggingEvent();
                if (this.layout.getHeader() != null) {
                    if (this.headerLayout == null) {
                        String header = this.layout.getHeader();
                        header = StringUtils.replace((String)header, (String)"%o", (String)"{number_of_occurrences}");
                        this.headerLayout = new PatternLayout(header);
                    }
                    if ((t = this.headerLayout.format(event)) != null) {
                        t = StringUtils.replace((String)t, (String)"{number_of_occurrences}", (String)Integer.toString(lea.getCount()));
                        sbuf.append(t);
                        sbuf.append("\n");
                    }
                }
                if (this.subjectLayout != null) {
                    String subject = this.subjectLayout.format(event);
                    if (subject != null && (subject = subject.trim()).indexOf("\n") > 0) {
                        subject = subject.substring(0, subject.indexOf("\n"));
                    }
                    this.msg.setSubject(subject);
                }
                sbuf.append(this.layout.format(event));
                if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
                    for (String element : s) {
                        sbuf.append(element);
                    }
                }
                if ((t = this.layout.getFooter()) != null) {
                    t = StringUtils.replace((String)t, (String)"%n", (String)Layout.LINE_SEP);
                    sbuf.append(t);
                }
                part.setContent((Object)sbuf.toString(), this.layout.getContentType());
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)part);
                this.msg.setContent((Multipart)mp);
                this.msg.setSentDate(new Date());
                Transport.send((Message)this.msg);
            }
        }
        catch (Exception e) {
            LogLog.error((String)"Error occured while sending e-mail notification.", (Throwable)e);
        }
    }

    public String getEvaluatorClass() {
        return this.evaluator == null ? null : this.evaluator.getClass().getName();
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subjectLayout.toString();
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setSubject(String subjectPattern) {
        this.subjectLayout = new PatternLayout(subjectPattern);
    }

    @Deprecated
    public void setBufferSize(int bufferSize) {
        LogLog.warn((String)("BufferSize property is deprecated for " + ((Object)((Object)this)).getClass().getName()));
    }

    public void setSMTPHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public int getBufferSize() {
        return 0;
    }

    public void setEvaluatorClass(String value) {
        this.evaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName((String)value, TriggeringEventEvaluator.class, (Object)this.evaluator);
    }

    public void setEvaluator(TriggeringEventEvaluator value) {
        this.evaluator = value;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

