/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.log4j;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class FilteredPatternLayout
extends PatternLayout {
    private Set<String> filteredFrames = new HashSet<String>();
    private String header;
    private String footer;
    private static String lineSeparator = "\n";

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public String format(LoggingEvent event) {
        ThrowableInformation throwableInformation = event.getThrowableInformation();
        if (throwableInformation == null) {
            return super.format(event);
        }
        return super.format(event) + this.getFilteredStacktrace(throwableInformation);
    }

    public void setFilter(String filter) {
        this.filteredFrames.add("at " + filter);
    }

    private String getFilteredStacktrace(ThrowableInformation throwableInformation) {
        StringBuilder buffer = new StringBuilder();
        String[] s = throwableInformation.getThrowableStrRep();
        for (int j = 0; j < s.length; ++j) {
            String string = s[j];
            if (this.startsWithAFilteredPAttern(string)) continue;
            buffer.append(string);
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    private boolean startsWithAFilteredPAttern(String string) {
        Iterator<String> iterator = this.filteredFrames.iterator();
        while (iterator.hasNext()) {
            if (!string.trim().startsWith(iterator.next())) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            lineSeparator = System.getProperty("line.separator");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

