// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package com.plantuml.api.cheerpj;

import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream extends OutputStream {

	private final StringBuilder sb = new StringBuilder();

	private int nb;
	private byte a;
	private byte b;
	private byte c;

	@Override
	public void write(int data) throws IOException {
		switch (nb) {
		case 0:
			a = (byte) (data & 0xFF);
			nb = 1;
			break;
		case 1:
			b = (byte) (data & 0xFF);
			nb = 2;
			break;
		case 2:
			c = (byte) (data & 0xFF);
			nb = 0;
			append3bytes(sb, a, b, c);
			break;
		}
	}

	@Override
	public void close() throws IOException {
		switch (nb) {
		case 0:
			break;
		case 1:
			append3bytes(sb, a, (byte) 0, (byte) 0);
			break;
		case 2:
			append3bytes(sb, a, b, (byte) 0);
			break;
		}
		super.close();
	}

	@Override
	public String toString() {
		return sb.toString();
	}

	private void append3bytes(StringBuilder sb, byte a, byte b, byte c) {
		final int i0 = a & 0xff;
		final int i1 = b & 0xff;
		final int i2 = c & 0xff;
		final int o0 = i0 >>> 2;
		final int o1 = ((i0 & 3) << 4) | (i1 >>> 4);
		final int o2 = ((i1 & 0xf) << 2) | (i2 >>> 6);
		final int o3 = i2 & 0x3F;
		sb.append(getBase(o0));
		sb.append(getBase(o1));
		sb.append(getBase(o2));
		sb.append(getBase(o3));
	}

	private String getBase(int i) {
		switch (i) {
		case 0:
			return "A";
		case 1:
			return "B";
		case 2:
			return "C";
		case 3:
			return "D";
		case 4:
			return "E";
		case 5:
			return "F";
		case 6:
			return "G";
		case 7:
			return "H";
		case 8:
			return "I";
		case 9:
			return "J";
		case 10:
			return "K";
		case 11:
			return "L";
		case 12:
			return "M";
		case 13:
			return "N";
		case 14:
			return "O";
		case 15:
			return "P";
		case 16:
			return "Q";
		case 17:
			return "R";
		case 18:
			return "S";
		case 19:
			return "T";
		case 20:
			return "U";
		case 21:
			return "V";
		case 22:
			return "W";
		case 23:
			return "X";
		case 24:
			return "Y";
		case 25:
			return "Z";
		case 26:
			return "a";
		case 27:
			return "b";
		case 28:
			return "c";
		case 29:
			return "d";
		case 30:
			return "e";
		case 31:
			return "f";
		case 32:
			return "g";
		case 33:
			return "h";
		case 34:
			return "i";
		case 35:
			return "j";
		case 36:
			return "k";
		case 37:
			return "l";
		case 38:
			return "m";
		case 39:
			return "n";
		case 40:
			return "o";
		case 41:
			return "p";
		case 42:
			return "q";
		case 43:
			return "r";
		case 44:
			return "s";
		case 45:
			return "t";
		case 46:
			return "u";
		case 47:
			return "v";
		case 48:
			return "w";
		case 49:
			return "x";
		case 50:
			return "y";
		case 51:
			return "z";
		case 52:
			return "0";
		case 53:
			return "1";
		case 54:
			return "2";
		case 55:
			return "3";
		case 56:
			return "4";
		case 57:
			return "5";
		case 58:
			return "6";
		case 59:
			return "7";
		case 60:
			return "8";
		case 61:
			return "9";
		case 62:
			return "+";
		case 63:
			return "/";

		}
		return "*";
	}

}
