// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.argon2;

import net.sourceforge.plantuml.argon2.model.Argon2Type;

public class Constants {

	/* Memory block size in bytes */
	public static final int ARGON2_BLOCK_SIZE = 1024;
	public static final int ARGON2_QWORDS_IN_BLOCK = ARGON2_BLOCK_SIZE / 8;
	/*
	 * Number of pseudo-random values generated by one call to Blake in Argon2i to
	 * generate reference block positions
	 */
	public static final int ARGON2_ADDRESSES_IN_BLOCK = 128;
	/* Pre-hashing digest length and its extension */
	public static final int ARGON2_PREHASH_DIGEST_LENGTH = 64;
	public static final int ARGON2_PREHASH_SEED_LENGTH = 72;
	/* Number of synchronization points between lanes per pass */
	public static final int ARGON2_SYNC_POINTS = 4;
	/* Flags to determine which fields are securely wiped (default = no wipe). */
	public static final int ARGON2_DEFAULT_FLAGS = 0;
	public static final int ARGON2_VERSION_10 = 0x10;
	public static final int ARGON2_VERSION_13 = 0x13;

	public static class Defaults {

		public static final int OUTLEN_DEF = 32;
		public static final int T_COST_DEF = 3;
		public static final int LOG_M_COST_DEF = 12;
		public static final int LANES_DEF = 1;
		public static final Argon2Type TYPE_DEF = Argon2Type.Argon2i;
		public static final int VERSION_DEF = ARGON2_VERSION_13;
		public static final int ARGON2_VERSION_NUMBER = ARGON2_VERSION_13;
		public static final boolean ENCODED_ONLY = false;
		public static final boolean RAW_ONLY = false;
	}
	// public static int ARGON2_FLAG_CLEAR_PASSWORD (UINT32_C(1) << 0)
	// public static int ARGON2_FLAG_CLEAR_SECRET (UINT32_C(1) << 1)

	/*
	 * Argon2 input parameter restrictions
	 */
	public static class Constraints {

		public static final int MAX_PASSWORD_LEN = 128;

		/* Minimum and maximum number of lanes (degree of parallelism) */
		public static final int MIN_PARALLELISM = 1;
		public static final int MAX_PARALLELISM = 16777216;

		/* Minimum and maximum digest size in bytes */
		public static final int MIN_OUTLEN = 4;
		public static final int MAX_OUTLEN = Integer.MAX_VALUE;

		/* Minimum and maximum number of memory blocks (each of BLOCK_SIZE bytes) */
		public static final int MIN_MEMORY = (2 * ARGON2_SYNC_POINTS); /* 2 blocks per slice */

		/* Minimum and maximum number of passes */
		public static final int MIN_ITERATIONS = 1;
		public static final int MAX_ITERATIONS = Integer.MAX_VALUE;

		/* Minimum and maximum password length in bytes */
		public static final int MIN_PWD_LENGTH = 0;
		public static final int MAX_PWD_LENGTH = Integer.MAX_VALUE;

		/* Minimum and maximum salt length in bytes */
		public static final int MIN_SALT_LENGTH = 0;
		public static final int MAX_SALT_LENGTH = Integer.MAX_VALUE;

		/* Minimum and maximum key length in bytes */
		public static final int MAX_SECRET_LENGTH = Integer.MAX_VALUE;

		/* Minimum and maximum associated model length in bytes */
		public static final int MAX_AD_LENGTH = Integer.MAX_VALUE;
	}

	public static class Messages {
		public static final String P_MIN_MSG = "degree of parallelism cannot be smaller than one";
		public static final String P_MAX_MSG = "parallelism cannot be greater than 16777216";

		public static final String M_MIN_MSG = "memory too small";

		public static final String T_MIN_MSG = "number of iterations cannot be less than one";
		public static final String T_MAX_MSG = "number of iterations too high";

		public static final String PWD_MIN_MSG = "password too short";
		public static final String PWD_MAX_MSG = "password too long";

		public static final String SALT_MIN_MSG = "salt too short";
		public static final String SALT_MAX_MSG = "salt too long";

		public static final String SECRET_MAX_MSG = "secret too long";
		public static final String ADDITIONAL_MAX_MSG = "additional data too long";

	}

}
