// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.bpm;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.sourceforge.plantuml.bpm.ConnectorPuzzle.Where;
import net.sourceforge.plantuml.style.ISkinParam;

public class Grid {

	private final Chain<Line> lines;
	private final Chain<Col> cols;
	private final Coord root;
	private final Map<Coord, Cell> cells = new HashMap<Coord, Cell>();

	public Grid() {
		this.root = new Coord(new Line(), new Col());
		this.lines = new ChainImpl<>(root.getLine());
		this.cols = new ChainImpl<>(root.getCol());
		this.cells.put(root, new Cell());
	}

	private Grid(Grid other) {
		this.lines = ((ChainImpl<Line>) other.lines).cloneMe();
		this.cols = ((ChainImpl<Col>) other.cols).cloneMe();
		this.root = other.root;
		this.cells.putAll(other.cells);
	}

	public Grid cloneMe() {
		return new Grid(this);
	}

	public Cell getCell(Coord coord) {
		return getCell(coord.getLine(), coord.getCol());
	}

	public Cell getCell(Line line, Col col) {
		if (lines.contains(line) == false) {
			throw new IllegalArgumentException();
		}
		if (cols.contains(col) == false) {
			throw new IllegalArgumentException();
		}
		final Coord coord = new Coord(line, col);
		Cell result = cells.get(coord);
		if (result == null) {
			result = new Cell();
			cells.put(coord, result);
		}
		return result;
	}

	// private Set<GridEdge> edgeWith(Cell someCell) {
	// // final Set<GridEdge> result = new HashSet<>();
	// // for (GridEdge edge : edges) {
	// // if (edge.match(someCell)) {
	// // result.add(edge);
	// // }
	// // }
	// // return Collections.unmodifiableSet(result);
	// throw new UnsupportedOperationException();
	//
	// }
	//
	// private Collection<Cell> getCellsConnectedTo(Cell someCell) {
	// final Set<Cell> result = new HashSet<>();
	// final Set<GridEdge> myEdges = edgeWith(someCell);
	// for (Cell cell : cells.values()) {
	// for (GridEdge edge : myEdges) {
	// assert edge.match(someCell);
	// if (edge.match(cell)) {
	// result.add(cell);
	// }
	// }
	// }
	// return Collections.unmodifiableSet(result);
	// }
	//
	// private SortedSet<Col> getColsConnectedTo(Cell someCell) {
	// final SortedSet<Col> result = new TreeSet<>(cols);
	// final Set<GridEdge> myEdges = edgeWith(someCell);
	// for (Map.Entry<Coord, Cell> ent : cells.entrySet()) {
	// for (GridEdge edge : myEdges) {
	// assert edge.match(someCell);
	// if (edge.match(ent.getValue())) {
	// result.add(ent.getKey().getCol());
	// }
	// }
	// }
	// return Collections.unmodifiableSortedSet(result);
	// }

	// public SortedSet<Col> colsConnectedTo(Line line) {
	// final SortedSet<Col> result = new TreeSet<>(cols);
	// for (Map.Entry<Coord, Cell> ent : cells.entrySet()) {
	// final Cell cell = ent.getValue();
	// if (cell == null || cell.getData() == null) {
	// continue;
	// }
	// if (ent.getKey().getLine() != line) {
	// continue;
	// }
	// result.addAll(getColsConnectedTo(ent.getValue()));
	//
	// }
	// return Collections.unmodifiableSortedSet(result);
	// }

	public Coord getById(String id) {
		for (Map.Entry<Coord, Cell> ent : cells.entrySet()) {
			final Cell cell = ent.getValue();
			if (cell == null || cell.getData() == null) {
				continue;
			}
			if (id.equals(cell.getData().getId())) {
				return ent.getKey();
			}
		}
		return null;
	}

	public final Coord getRoot() {
		return root;
	}

	public final Chain<Line> lines() {
		return lines;
	}

	public final Chain<Col> cols() {
		return cols;
	}

	public final Coord getCoord(Cell cell) {
		for (Map.Entry<Coord, Cell> ent : cells.entrySet()) {
			if (ent.getValue() == cell) {
				return ent.getKey();
			}
		}
		throw new IllegalArgumentException();
	}

	private Coord getCoord(Placeable placeable) {
		for (Map.Entry<Coord, Cell> ent : cells.entrySet()) {
			if (ent.getValue().getData() == placeable) {
				return ent.getKey();
			}
		}
		throw new IllegalArgumentException();
	}

	public final Navigator<Line> linesOf(Coord coord) {
		return lines.navigator(coord.getLine());
	}

	public final Navigator<Col> colsOf(Coord coord) {
		return cols.navigator(coord.getCol());
	}

	public final Navigator<Line> linesOf(Cell cell) {
		return linesOf(getCoord(cell));
	}

	public final Navigator<Col> colsOf(Cell cell) {
		return colsOf(getCoord(cell));
	}

	public final GridArray toArray(ISkinParam skinParam) {
		final List<Line> lines = this.lines.toList();
		final List<Col> cols = this.cols.toList();
		final GridArray result = new GridArray(skinParam, lines.size(), cols.size());
		for (Map.Entry<Coord, Cell> ent : cells.entrySet()) {
			final int l = lines.indexOf(ent.getKey().getLine());
			final int c = cols.indexOf(ent.getKey().getCol());
			if (c == -1) {
				throw new IllegalStateException("col=" + ent.getKey().getCol());
			}
			if (l == -1) {
				throw new IllegalStateException("line=" + ent.getKey().getLine());
			}
			result.setData(l, c, ent.getValue().getData());
		}
		return result;
	}

	// public boolean isRowEmpty(Col row) {
	// System.err.println("Testing Row " + row);
	// for (Map.Entry<Coord, Cell> ent : cells.entrySet()) {
	// final Cell cell = ent.getValue();
	// if (cell == null || cell.getData() == null) {
	// continue;
	// }
	// if (ent.getKey().getCol() == row) {
	// System.err.println("Not empty " + cell + " " + cell.getData());
	// return false;
	// }
	// }
	// System.err.println("EMPTY!!!");
	// return true;
	// }

	// public boolean isLineEmpty(Line line) {
	// for (Map.Entry<Coord, Cell> ent : cells.entrySet()) {
	// final Cell cell = ent.getValue();
	// if (cell == null || cell.getData() == null) {
	// continue;
	// }
	// if (ent.getKey().getLine() == line) {
	// return false;
	// }
	// }
	// return true;
	// }

	public Set<Col> usedColsOf(Line line) {
		final Set<Col> result = new HashSet<>();
		for (Map.Entry<Coord, Cell> ent : cells.entrySet()) {
			final Cell cell = ent.getValue();
			if (cell == null || cell.getData() == null) {
				continue;
			}
			if (ent.getKey().getLine() == line) {
				result.add(ent.getKey().getCol());
			}
		}
		return Collections.unmodifiableSet(result);
	}

	public void removeLine(Line line) {
		assert usedColsOf(line).isEmpty();
		for (final Iterator<Map.Entry<Coord, Cell>> it = cells.entrySet().iterator(); it.hasNext();) {
			final Map.Entry<Coord, Cell> ent = it.next();
			if (ent.getKey().getLine() != line) {
				continue;
			}
			final Cell cell = ent.getValue();
			if (cell == null || cell.getData() == null) {
				it.remove();
			} else {
				throw new IllegalStateException();
			}
		}

		final boolean done = lines.remove(line);
		if (done == false) {
			throw new IllegalArgumentException();
		}
	}

	// public void addEdge(Collection<GridEdge> other) {
	// this.edges.addAll(other);
	// }

	// public void mergeLines(Line line1, Line line2) {
	// final Map<Coord, Cell> supp = new HashMap<Coord, Cell>();
	//
	// for (Iterator<Map.Entry<Coord, Cell>> it = cells.entrySet().iterator();
	// it.hasNext();) {
	// final Map.Entry<Coord, Cell> ent = it.next();
	// final Cell cell = ent.getValue();
	// if (cell == null || cell.getData() == null) {
	// continue;
	// }
	// if (ent.getKey().getLine() == source) {
	// supp.put(new Coord(dest, ent.getKey().getCol()), cell);
	// it.remove();
	// }
	// }
	// cells.putAll(supp);
	// removeLine(source);
	// }

	public void addConnections() {
		for (Map.Entry<Coord, Cell> ent : new HashMap<>(cells).entrySet()) {
			final List<Placeable> dests2 = ent.getValue().getDestinations2();
			final Coord src = ent.getKey();
			for (int i = 0; i < dests2.size(); i++) {
				final Coord dest = getCoord(dests2.get(i));
				final boolean startHorizontal = i == 0;
				if (startHorizontal) {
					// System.err.println("DrawingHorizontal " + ent.getValue() + " --> " +
					// dests.get(i) + " " + i);
					drawStartHorizontal(src, dest);
				} else {
					drawStartVertical(src, dest);
				}
			}
		}
	}

	private void drawStartVertical(final Coord src, final Coord dest) {
		if (src.getLine() == dest.getLine() && src.getCol() == dest.getCol()) {
			throw new IllegalStateException();
		}
		final BpmElement start = (BpmElement) getCell(src).getData();
		final int compare = lines.compare(src.getLine(), dest.getLine());
		if (compare == 0) {
			throw new IllegalStateException();
		}
		start.append(compare < 0 ? Where.SOUTH : Where.NORTH);

		for (Navigator<Line> itLine = Navigators.iterate(lines, src.getLine(), dest.getLine()); itLine.get() != dest
				.getLine();) {
			final Line cur = itLine.next();
			if (cur != dest.getLine()) {
				addPuzzle(cur, src.getCol(), "NS");
			}
		}
		for (Navigator<Col> itCol = Navigators.iterate(cols, src.getCol(), dest.getCol()); itCol.get() != dest
				.getCol();) {
			final Col cur = itCol.next();
			if (cur != dest.getCol()) {
				addPuzzle(dest.getLine(), cur, "EW");
			}
		}
		final BpmElement end = (BpmElement) getCell(dest).getData();
		if (src.getLine() == dest.getLine()) {
			end.append(compare < 0 ? Where.NORTH : Where.SOUTH);
		}
		if (src.getLine() != dest.getLine() && src.getCol() != dest.getCol()) {
			if (lines.compare(dest.getLine(), src.getLine()) > 0) {
				addPuzzle(dest.getLine(), src.getCol(), "N");
			} else {
				addPuzzle(dest.getLine(), src.getCol(), "S");
			}
			if (cols.compare(dest.getCol(), src.getCol()) > 0) {
				addPuzzle(dest.getLine(), src.getCol(), "E");
			} else {
				addPuzzle(dest.getLine(), src.getCol(), "W");
			}
			end.append(cols.compare(src.getCol(), dest.getCol()) > 0 ? Where.EAST : Where.WEST);
		}

	}

	private void drawStartHorizontal(final Coord src, final Coord dest) {
		if (src.getLine() == dest.getLine() && src.getCol() == dest.getCol()) {
			throw new IllegalStateException();
		}
		final BpmElement start = (BpmElement) getCell(src).getData();
		final int compare = cols.compare(src.getCol(), dest.getCol());
		if (compare == 0) {
			throw new IllegalStateException();
		}
		start.append(compare < 0 ? Where.EAST : Where.WEST);

		for (Navigator<Col> itCol = Navigators.iterate(cols, src.getCol(), dest.getCol()); itCol.get() != dest
				.getCol();) {
			final Col cur = itCol.next();
			if (cur != dest.getCol()) {
				addPuzzle(src.getLine(), cur, "EW");
			}
		}
		for (Navigator<Line> itLine = Navigators.iterate(lines, src.getLine(), dest.getLine()); itLine.get() != dest
				.getLine();) {
			final Line cur = itLine.next();
			if (cur != dest.getLine()) {
				addPuzzle(cur, dest.getCol(), "NS");
			}
		}
		final BpmElement end = (BpmElement) getCell(dest).getData();
		if (src.getLine() == dest.getLine()) {
			end.append(compare < 0 ? Where.WEST : Where.EAST);
		}
		if (src.getLine() != dest.getLine() && src.getCol() != dest.getCol()) {
			if (cols.compare(dest.getCol(), src.getCol()) > 0) {
				addPuzzle(src.getLine(), dest.getCol(), "W");
			} else {
				addPuzzle(src.getLine(), dest.getCol(), "E");
			}
			if (lines.compare(dest.getLine(), src.getLine()) > 0) {
				addPuzzle(src.getLine(), dest.getCol(), "S");
			} else {
				addPuzzle(src.getLine(), dest.getCol(), "N");
			}
			end.append(lines.compare(src.getLine(), dest.getLine()) > 0 ? Where.SOUTH : Where.NORTH);
		}
	}

	private void addPuzzle(Line line, Col col, String direction) {
		final Cell cell = getCell(line, col);
		ConnectorPuzzleEmpty connector = (ConnectorPuzzleEmpty) cell.getData();
		if (connector == null) {
			connector = new ConnectorPuzzleEmpty();
			cell.setData(connector);
		}
		connector.append(ConnectorPuzzleEmpty.get(direction));
	}

}
