// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */

package net.sourceforge.plantuml.brotli;

/**
 * Utilities for building Huffman decoding tables.
 */
final class Huffman {

	private static final int MAX_LENGTH = 15;

	/**
	 * Returns reverse(reverse(key, len) + 1, len).
	 *
	 * <p>
	 * reverse(key, len) is the bit-wise reversal of the len least significant bits
	 * of key.
	 */
	private static int getNextKey(int key, int len) {
		int step = 1 << (len - 1);
		while ((key & step) != 0) {
			step >>= 1;
		}
		return (key & (step - 1)) + step;
	}

	/**
	 * Stores {@code item} in
	 * {@code table[0], table[step], table[2 * step] .., table[end]}.
	 *
	 * <p>
	 * Assumes that end is an integer multiple of step.
	 */
	private static void replicateValue(int[] table, int offset, int step, int end, int item) {
		do {
			end -= step;
			table[offset + end] = item;
		} while (end > 0);
	}

	/**
	 * @param count histogram of bit lengths for the remaining symbols,
	 * @param len   code length of the next processed symbol.
	 * @return table width of the next 2nd level table.
	 */
	private static int nextTableBitSize(int[] count, int len, int rootBits) {
		int left = 1 << (len - rootBits);
		while (len < MAX_LENGTH) {
			left -= count[len];
			if (left <= 0) {
				break;
			}
			len++;
			left <<= 1;
		}
		return len - rootBits;
	}

	/**
	 * Builds Huffman lookup table assuming code lengths are in symbol order.
	 */
	static void buildHuffmanTable(int[] rootTable, int tableOffset, int rootBits, int[] codeLengths,
			int codeLengthsSize) {
		int key; // Reversed prefix code.
		int[] sorted = new int[codeLengthsSize]; // Symbols sorted by code length.
		// TODO: fill with zeroes?
		int[] count = new int[MAX_LENGTH + 1]; // Number of codes of each length.
		int[] offset = new int[MAX_LENGTH + 1]; // Offsets in sorted table for each length.
		int symbol;

		// Build histogram of code lengths.
		for (symbol = 0; symbol < codeLengthsSize; symbol++) {
			count[codeLengths[symbol]]++;
		}

		// Generate offsets into sorted symbol table by code length.
		offset[1] = 0;
		for (int len = 1; len < MAX_LENGTH; len++) {
			offset[len + 1] = offset[len] + count[len];
		}

		// Sort symbols by length, by symbol order within each length.
		for (symbol = 0; symbol < codeLengthsSize; symbol++) {
			if (codeLengths[symbol] != 0) {
				sorted[offset[codeLengths[symbol]]++] = symbol;
			}
		}

		int tableBits = rootBits;
		int tableSize = 1 << tableBits;
		int totalSize = tableSize;

		// Special case code with only one value.
		if (offset[MAX_LENGTH] == 1) {
			for (key = 0; key < totalSize; key++) {
				rootTable[tableOffset + key] = sorted[0];
			}
			return;
		}

		// Fill in root table.
		key = 0;
		symbol = 0;
		for (int len = 1, step = 2; len <= rootBits; len++, step <<= 1) {
			for (; count[len] > 0; count[len]--) {
				replicateValue(rootTable, tableOffset + key, step, tableSize, len << 16 | sorted[symbol++]);
				key = getNextKey(key, len);
			}
		}

		// Fill in 2nd level tables and add pointers to root table.
		int mask = totalSize - 1;
		int low = -1;
		int currentOffset = tableOffset;
		for (int len = rootBits + 1, step = 2; len <= MAX_LENGTH; len++, step <<= 1) {
			for (; count[len] > 0; count[len]--) {
				if ((key & mask) != low) {
					currentOffset += tableSize;
					tableBits = nextTableBitSize(count, len, rootBits);
					tableSize = 1 << tableBits;
					totalSize += tableSize;
					low = key & mask;
					rootTable[tableOffset + low] = (tableBits + rootBits) << 16 | (currentOffset - tableOffset - low);
				}
				replicateValue(rootTable, currentOffset + (key >> rootBits), step, tableSize,
						(len - rootBits) << 16 | sorted[symbol++]);
				key = getNextKey(key, len);
			}
		}
	}
}
