// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.klimt.shape;

import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class UHorizontalLine implements UShape {
    // ::remove file when __HAXE__

	private final double skipAtStart;
	private final double skipAtEnd;
	private final TextBlock title;
	private final boolean blankTitle;
	private final char style;
	private final double defaultThickness;

	private UHorizontalLine(double defaultThickness, double skipAtStart, double skipAtEnd, TextBlock title,
			boolean blankTitle, char style) {
		this.defaultThickness = defaultThickness;
		this.skipAtEnd = skipAtEnd;
		this.skipAtStart = skipAtStart;
		this.title = title;
		this.blankTitle = blankTitle;
		this.style = style;
	}

	public static UHorizontalLine infinite(double defaultThickness, double skipAtStart, double skipAtEnd, char style) {
		return new UHorizontalLine(defaultThickness, skipAtStart, skipAtEnd, null, false, style);
	}

	public static UHorizontalLine infinite(double defaultThickness, double skipAtStart, double skipAtEnd,
			TextBlock title, char style) {
		return new UHorizontalLine(defaultThickness, skipAtStart, skipAtEnd, title, false, style);
	}

	public boolean isDouble() {
		return style == '=';
	}

	// static public UHorizontalLine infinite(UStroke stroke) {
	// return new UHorizontalLine(0, 0, null, false, stroke);
	// }

	public void drawLineInternal(final UGraphic ug, Stencil stencil, double y, UStroke defaultStroke) {
		stencil = addSkip(stencil);
		final UStroke strokeToUse = style == '\0' ? defaultStroke : getStroke();
		final UGraphic ugStroke = ug.apply(strokeToUse);
		if (title == null) {
			drawHLine(stencil, y, ugStroke);
			return;
		}
		final XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
		drawHLine(firstHalf(stencil, dimTitle.getWidth()), y, ugStroke);
		final double startingX = stencil.getStartingX(ug.getStringBounder(), y);
		final double endingX = stencil.getEndingX(ug.getStringBounder(), y);
		drawTitleInternal(ug, startingX, endingX, y, false);
		drawHLine(secondHalf(stencil, dimTitle.getWidth()), y, ugStroke);
	}

	private Stencil addSkip(final Stencil stencil) {
		return new Stencil() {
			public double getStartingX(StringBounder stringBounder, double y) {
				return stencil.getStartingX(stringBounder, y) + skipAtStart;
			}

			public double getEndingX(StringBounder stringBounder, double y) {
				return stencil.getEndingX(stringBounder, y) - skipAtEnd;
			}
		};
	}

	private static Stencil firstHalf(final Stencil stencil, final double widthTitle) {
		return new Stencil() {
			public double getStartingX(StringBounder stringBounder, double y) {
				return stencil.getStartingX(stringBounder, y);
			}

			public double getEndingX(StringBounder stringBounder, double y) {
				final double start = stencil.getStartingX(stringBounder, y);
				final double end = stencil.getEndingX(stringBounder, y);
				final double len = (end - start - widthTitle) / 2;
				return start + len;
			}
		};
	}

	private static Stencil secondHalf(final Stencil stencil, final double widthTitle) {
		return new Stencil() {
			public double getStartingX(StringBounder stringBounder, double y) {
				final double start = stencil.getStartingX(stringBounder, y);
				final double end = stencil.getEndingX(stringBounder, y);
				final double len = (end - start - widthTitle) / 2;
				return end - len;
			}

			public double getEndingX(StringBounder stringBounder, double y) {
				return stencil.getEndingX(stringBounder, y);
			}
		};
	}

	private void drawHLine(Stencil stencil, double y, final UGraphic ug) {
		drawSimpleHline(ug, stencil, y);
		if (style == '=')
			drawSimpleHline(ug, stencil, y + 2);

	}

	private static void drawSimpleHline(UGraphic ug, Stencil stencil, double y) {
		final double startingX = stencil.getStartingX(ug.getStringBounder(), y);
		final double endingX = stencil.getEndingX(ug.getStringBounder(), y);
		ug.apply(new UTranslate(startingX, y)).draw(ULine.hline(endingX - startingX));
	}

	public void drawTitleInternal(UGraphic ug, double startingX, double endingX, double y, boolean clearArea) {
		if (title == null || blankTitle) {
			return;
		}
		final double widthToUse = endingX - startingX;
		final XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
		final double space = (widthToUse - dimTitle.getWidth()) / 2;
		final double x1 = startingX + space;
		final double y1 = y - dimTitle.getHeight() / 2 - 0.5;
		ug = ug.apply(new UTranslate(x1, y1));
		if (clearArea) {
			ug.apply(getStroke()).draw(URectangle.build(dimTitle));
		}
		title.drawU(ug);
	}

	public void drawMe(UGraphic ug) {
		ug.draw(this);
	}

	public UStroke getStroke() {
		if (style == '\0')
			throw new IllegalStateException();
		else if (style == '=')
			return UStroke.simple();
		else if (style == '.')
			return new UStroke(1, 2, 1);
		else if (style == '-')
			return UStroke.simple();
		else
			return UStroke.withThickness(defaultThickness);

	}

}
