// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.picoweb;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class ReceivedHTTPRequest {

	private static final String CONTENT_LENGTH_HEADER = "content-length: ";

	private String method;

	private String path;

	private byte[] body;

	public String getMethod() {
		return method;
	}

	public String getPath() {
		return path;
	}

	public byte[] getBody() {
		return body;
	}

	public static ReceivedHTTPRequest fromStream(InputStream in) throws IOException {
		final ReceivedHTTPRequest request = new ReceivedHTTPRequest();

		final String requestLine = readLine(in);

		final StringTokenizer tokenizer = new StringTokenizer(requestLine);
		if (tokenizer.countTokens() != 3) {
			throw new BadRequest400("Bad request line");
		}

		request.method = tokenizer.nextToken().toUpperCase();
		request.path = tokenizer.nextToken();

		// Headers
		int contentLength = 0;

		while (true) {
			String line = readLine(in);
			if (line.isEmpty()) {
				break;
			} else if (line.toLowerCase().startsWith(CONTENT_LENGTH_HEADER)) {
				contentLength = parseContentLengthHeader(line);
			}
		}

		request.body = readBody(in, contentLength);
		return request;
	}

	private static int parseContentLengthHeader(String line) throws IOException {
		int contentLength;

		try {
			contentLength = Integer.parseInt(line.substring(CONTENT_LENGTH_HEADER.length()).trim());
		} catch (NumberFormatException e) {
			throw new BadRequest400("Invalid content length");
		}

		if (contentLength < 0) {
			throw new BadRequest400("Negative content length");
		}

		return contentLength;
	}

	private static byte[] readBody(InputStream in, int contentLength) throws IOException {
		if (contentLength == 0) {
			return new byte[0];
		}

		final byte[] body = new byte[contentLength];
		int n = 0;
		int offset = 0;

		// java.io.InputStream.readNBytes() can replace this from Java 9
		while (n < contentLength) {
			int count = in.read(body, offset + n, contentLength - n);
			if (count < 0) {
				throw new BadRequest400("Body too short");
			}
			n += count;
		}
		return body;
	}

	private static String readLine(InputStream in) throws IOException {
		final StringBuilder builder = new StringBuilder();

		while (true) {
			int c = in.read();
			if (c == -1 || c == '\n') {
				break;
			}
			builder.append((char) c);
		}

		if (builder.length() > 0 && builder.charAt(builder.length() - 1) == '\r') {
			builder.deleteCharAt(builder.length() - 1);
		}

		return builder.toString();
	}
}
