// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.security;

/**
 * There are 4 different security profile defined.
 * <p>
 * The security profile to be used is set at the launch of PlantUML and cannot
 * be changed by users. The security profile defines what an instance of
 * PlantUML is allowed to do:<br>
 * - access some local file <br>
 * - connection to some remote URL <br>
 * - print some technical information to the users.
 * <p>
 * <p>
 * The security profile is defined: <br>
 * - either by an environment variable<br>
 * - or an option at command line
 * <p>
 * There is also a default value, which is LEGACY in this current
 * implementation.
 * 
 */
public enum SecurityProfile {
	// ::remove folder when __HAXE__

	/**
	 * Running in SANDBOX mode is completely secure. No local file can be read
	 * (except dot executable) No remote URL access can be used No technical
	 * information are print to users.
	 * <p>
	 * This mode is defined for test and debug, since it's not very useful for
	 * users. However, you can use it if you need to.
	 */
	SANDBOX,

	/**
	 * 
	 */
	ALLOWLIST,

	/**
	 * This mode is designed for PlantUML running in a web server.
	 * 
	 */
	INTERNET,

	/**
	 * This mode reproduce old PlantUML version behaviour.
	 * <p>
	 * Right now, this is the default Security Profile but this will be removed from
	 * future version because it is now full secure, especially on Internet server.
	 */
	LEGACY,

	/**
	 * Running in UNSECURE mode means that PlantUML can access to any local file and
	 * can connect to any URL.
	 * <p>
	 * Some technical information (file path, Java version) are also printed in some
	 * error messages. This is not an issue if you are running PlantUML locally. But
	 * you should not use this mode if PlantUML is running on some server,
	 * especially if the server is accessible from Internet.
	 */
	UNSECURE;

	/**
	 * Initialize the default value.
	 * <p>
	 * It search in some config variable if the user has defined a some default
	 * value.
	 * 
	 * @return the value
	 */
	static SecurityProfile init() {
		// ::comment when __CORE__
		final String env = SecurityUtils.getenv("PLANTUML_SECURITY_PROFILE");
		if ("SANDBOX".equalsIgnoreCase(env))
			return SANDBOX;
		else if ("ALLOWLIST".equalsIgnoreCase(env))
			return ALLOWLIST;
		else if ("INTERNET".equalsIgnoreCase(env))
			return INTERNET;
		else if ("UNSECURE".equalsIgnoreCase(env))
			return UNSECURE;
		// ::comment when __CORE__

		return LEGACY;
	}

	/**
	 * A Human understandable description.
	 */
	public String longDescription() {
		switch (this) {
		case SANDBOX:
			return "This is completely safe: no access to local files or to distant URL.";
		case ALLOWLIST:
			return "Some local resource may be accessible.";
		case INTERNET:
			return "<i>Mode designed for server connected to Internet.";
		case LEGACY:
			return "<b>Warning: this mode will be removed in future version";
		case UNSECURE:
			return "<b>Make sure that this server is not accessible from Internet";
		}
		return "<i>This is completely safe: no access on local files or on distant URL.";
	}

	/**
	 * Retrieve the timeout for URL.
	 */
	public long getTimeout() {
		switch (this) {
		case SANDBOX:
			return 1000L;
		case ALLOWLIST:
			return 1000L * 60 * 5;
		case INTERNET:
			return 1000L * 10;
		case LEGACY:
			return 1000L * 60;
		case UNSECURE:
			return 1000L * 60 * 5;
		}
		throw new AssertionError();
	}

	public boolean canWeReadThisEnvironmentVariable(String name) {
		if (name == null)
			return false;

		final String lname = name.toLowerCase();
		if (lname.startsWith("plantuml.security"))
			return false;

		if (lname.startsWith("plantuml"))
			return true;

		if (lname.equals("path.separator") || lname.equals("line.separator"))
			return true;

		return this == UNSECURE;
	}

}
