// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.stats;

import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeSet;

import net.sourceforge.plantuml.api.NumberAnalyzed;
import net.sourceforge.plantuml.stats.api.Stats;
import net.sourceforge.plantuml.stats.api.StatsColumn;
import net.sourceforge.plantuml.stats.api.StatsLine;
import net.sourceforge.plantuml.stats.api.StatsTable;

public class StatsImpl implements Stats {

	// private final long jvmcounting;

	private final FormatCounter formatCounterCurrent;
	private final FormatCounter formatCounterEver;

	private final Map<String, ParsedGenerated> byTypeEver;
	private final Map<String, ParsedGenerated> byTypeCurrent;

	private final ParsedGenerated fullEver;
	private final HistoricalData historicalData;

	StatsImpl(Map<String, ParsedGenerated> byTypeEver, Map<String, ParsedGenerated> byTypeCurrent,
			FormatCounter formatCounterCurrent, FormatCounter formatCounterEver, HistoricalData historicalData,
			ParsedGenerated fullEver) {
		// this.jvmcounting = jvmcounting;
		this.byTypeEver = byTypeEver;
		this.byTypeCurrent = byTypeCurrent;
		this.formatCounterCurrent = formatCounterCurrent;
		this.formatCounterEver = formatCounterEver;
		this.fullEver = fullEver;
		this.historicalData = historicalData;
	}

	private StatsLine createDataLineSession(final ParsedGenerated data) {
		final Map<StatsColumn, Object> result = new EnumMap<StatsColumn, Object>(StatsColumn.class);
		final long id = data.getId();
		if (id != -1) {
			result.put(StatsColumn.SESSION_ID, id);
		}
		result.put(StatsColumn.VERSION, data.getVersion());
		final long creationTime = data.parsedDated().getCreationTime();
		final long modificationTime = data.parsedDated().getModificationTime();
		result.put(StatsColumn.STARTING, new Date(creationTime));
		result.put(StatsColumn.LAST, new Date(modificationTime));
		result.put(StatsColumn.DURATION_STRING, new HumanDuration(modificationTime - creationTime));
		result.put(StatsColumn.PARSED_COUNT, data.parsedDated().getNb());
		result.put(StatsColumn.PARSED_MEAN_TIME, data.parsedDated().getMean());
		result.put(StatsColumn.PARSED_STANDARD_DEVIATION, data.parsedDated().getStandardDeviation());
		result.put(StatsColumn.PARSED_MAX_TIME, data.parsedDated().getMax());
		result.put(StatsColumn.GENERATED_COUNT, data.generatedDated().getNb());
		result.put(StatsColumn.GENERATED_MEAN_TIME, data.generatedDated().getMean());
		result.put(StatsColumn.GENERATED_STANDARD_DEVIATION, data.generatedDated().getStandardDeviation());
		result.put(StatsColumn.GENERATED_MAX_TIME, data.generatedDated().getMax());
		return new StatsLineImpl(result);
	}

	private StatsLine createLineByDiagramType(String key, NumberAnalyzed parse, NumberAnalyzed generate) {
		final Map<StatsColumn, Object> result = new EnumMap<StatsColumn, Object>(StatsColumn.class);
		result.put(StatsColumn.DIAGRAM_TYPE, key);
		result.put(StatsColumn.PARSED_COUNT, parse.getNb());
		result.put(StatsColumn.PARSED_MEAN_TIME, parse.getMean());
		result.put(StatsColumn.PARSED_STANDARD_DEVIATION, parse.getStandardDeviation());
		result.put(StatsColumn.PARSED_MAX_TIME, parse.getMax());
		result.put(StatsColumn.GENERATED_COUNT, generate.getNb());
		result.put(StatsColumn.GENERATED_MEAN_TIME, generate.getMean());
		result.put(StatsColumn.GENERATED_STANDARD_DEVIATION, generate.getStandardDeviation());
		result.put(StatsColumn.GENERATED_MAX_TIME, generate.getMax());
		return new StatsLineImpl(result);
	}

	public StatsTable getLastSessions() {
		final StatsTableImpl result = new StatsTableImpl("Statistics");
		for (ParsedGenerated histo : historicalData.getHistorical()) {
			result.addLine(createDataLineSession(histo));
		}
		if (historicalData.current() != null) {
			result.addLine(createDataLineSession(historicalData.current()));
		}
		result.addLine(createDataLineSession(fullEver));
		return result;
	}

	public StatsTable getCurrentSessionByFormat() {
		return formatCounterCurrent.getStatsTable("current format");
	}

	public StatsTable getAllByFormat() {
		return formatCounterEver.getStatsTable("all format");
	}

	public StatsTable getCurrentSessionByDiagramType() {
		return getByDiagramType("Current session", byTypeCurrent);
	}

	public StatsTable getAllByDiagramType() {
		return getByDiagramType("All session", byTypeEver);
	}

	private StatsTable getByDiagramType(String name, Map<String, ParsedGenerated> data) {
		final StatsTableImpl result = new StatsTableImpl(name);
		final TreeSet<String> keys = new TreeSet<>(data.keySet());
		final NumberAnalyzed totalParsing = new NumberAnalyzed();
		final NumberAnalyzed totalGenerating = new NumberAnalyzed();
		for (String key : keys) {
			final NumberAnalyzed parse = data.get(key).parsed();
			final NumberAnalyzed generate = data.get(key).generated();
			totalParsing.add(parse);
			totalGenerating.add(generate);
			result.addLine(createLineByDiagramType(key, parse, generate));
		}
		result.addLine(createLineByDiagramType("Total", totalParsing, totalGenerating));
		return result;
	}

	// public long totalLaunch() {
	// return jvmcounting;
	// }

}
