// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import net.sourceforge.plantuml.stereo.Stereostyles;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypeDecoration;
import net.sourceforge.plantuml.url.Url;

public class StyleSignatureBasic implements StyleSignature {
    // ::remove file when __HAXE__

	private final Set<String> names = new LinkedHashSet<>();
	private final boolean withDot;

	public StyleSignatureBasic(String s) {
		if (s.contains("*") || s.contains("&") || s.contains("-"))
			throw new IllegalArgumentException();

		this.withDot = s.contains(".");
		this.names.add(clean(s));
	}

	public static StyleSignatureBasic empty() {
		return new StyleSignatureBasic(false);
	}

	private StyleSignatureBasic(boolean withDot) {
		this.withDot = withDot;
	}

	private StyleSignatureBasic(boolean withDot, Collection<String> copy) {
		this.names.addAll(copy);
		this.withDot = withDot;
	}

	public StyleSignatureBasic addClickable(Url url) {
		if (url == null)
			return this;

		final Set<String> result = new LinkedHashSet<>(names);
		result.add(SName.clickable.name());
		return new StyleSignatureBasic(withDot, result);

	}

	public StyleSignatureBasic add(String s) {
		if (s == null)
			return this;

		if (s.contains("&"))
			throw new IllegalArgumentException();

		final Set<String> result = new LinkedHashSet<>(names);
		result.add(clean(s));
		return new StyleSignatureBasic(withDot || s.contains("."), result);
	}

	public StyleSignatureBasic addS(String s) {
		if (s == null)
			return this;

		if (s.contains("&"))
			throw new IllegalArgumentException();

		final Set<String> result = new LinkedHashSet<>(names);
		result.add(StereotypeDecoration.PREFIX + clean(s));
		return new StyleSignatureBasic(withDot || s.contains("."), result);
	}

	public StyleSignatureBasic add(SName name) {
		return add(name.name().toLowerCase().replace("_", ""));
	}

	public StyleSignatureBasic addStar() {
		final Set<String> result = new LinkedHashSet<>(names);
		result.add("*");
		return new StyleSignatureBasic(withDot, result);
	}

	public boolean isStarred() {
		return names.contains("*");
	}

	@Override
	public boolean equals(Object arg) {
		final StyleSignatureBasic other = (StyleSignatureBasic) arg;
		return this.names.equals(other.names);
	}

	@Override
	public int hashCode() {
		return names.hashCode();
	}

	@Override
	public String toString() {
		final StringBuilder result = new StringBuilder();
		for (String n : names) {
			if (result.length() > 0)
				result.append('.');

			result.append(n);
		}
		return result.toString() + " " + withDot;
	}

	public boolean matchAll(StyleSignatureBasic other) {
		final boolean namesContainsStar = names.contains("*");
		if (other.isStarred() && namesContainsStar == false)
			return false;

		final int depthInNames = depthFromTokens(other.names);

		for (String token : names) {
			if (token.equals("*"))
				continue;

			if (namesContainsStar && depthInNames != -1 && depthFromToken(token) != -1) {
				// depth comparaison
				if (depthInNames < depthFromToken(token))
					return false;
			} else {
				if (other.names.contains(token) == false)
					return false;
			}

		}
		return true;
	}

	private static int depthFromToken(String token) {
		if (token.startsWith("depth("))
			return Integer.parseInt(token.substring("depth(".length(), token.length() - 1));
		return -1;
	}

	private static int depthFromTokens(Collection<String> tokens) {
		for (String token : tokens) {
			final int depth = depthFromToken(token);
			if (depth != -1)
				return depth;
		}
		return -1;

	}

	public final Set<String> getNames() {
		return Collections.unmodifiableSet(names);
	}

	public static StyleSignatureBasic of(SName... names) {
		final List<String> result = new ArrayList<>();
		for (SName name : names)
			result.add(name.name().toLowerCase().replace("_", ""));

		return new StyleSignatureBasic(false, result);
	}

	public StyleSignature forStereotypeItself(Stereotype stereotype) {
		if (stereotype == null || stereotype.getStyleNames().size() == 0)
			return this;

		final StyleSignatures result = new StyleSignatures();
		for (String name : stereotype.getStyleNames()) {
			final List<String> tmp = new ArrayList<>(names);
			tmp.add(SName.stereotype.name().toLowerCase().replace("_", ""));
			tmp.add(clean(name));
			result.add(new StyleSignatureBasic(false, tmp));
		}
		return result;

	}

	@Override
	public StyleSignature withTOBECHANGED(Stereotype stereotype) {
		if (stereotype == null || stereotype.getStyleNames().size() == 0)
			return this;

		final StyleSignatures result = new StyleSignatures();
		for (String name : stereotype.getStyleNames()) {
			final List<String> tmp = new ArrayList<>(names);
			tmp.add(clean(name));
			result.add(new StyleSignatureBasic(true, tmp));
		}
		return result;
	}

	@Override
	public StyleSignature with(Stereostyles stereostyles) {
		if (stereostyles.isEmpty())
			return this;
		final List<String> result = new ArrayList<>(names);
		for (String name : stereostyles.getStyleNames())
			result.add(StereotypeDecoration.PREFIX + clean(name));

		return new StyleSignatureBasic(true, result);
	}

	private String clean(String name) {
		if (name.startsWith("."))
			name = StereotypeDecoration.PREFIX + name;

		return name.toLowerCase().replace("_", "").replace(".", "");
	}

	public StyleSignatureBasic mergeWith(List<Style> others) {
		final List<String> copy = new ArrayList<>(names);
		for (Style other : others)
			for (String s : other.getSignature().getNames())
				copy.add(s);

		return new StyleSignatureBasic(withDot, copy);
	}

	public StyleSignatureBasic mergeWith(StyleSignatureBasic other) {
		final List<String> copy = new ArrayList<>(names);
		copy.addAll(other.names);
		return new StyleSignatureBasic(withDot || other.withDot, copy);
	}

	@Override
	public Style getMergedStyle(StyleBuilder styleBuilder) {
		if (styleBuilder == null)
			return null;

		return styleBuilder.getMergedStyle(this);
	}

	public boolean match(Stereotype stereotype) {
		for (String s : stereotype.getMultipleLabels())
			if (names.contains(clean(s)))
				return true;

		return false;
	}

	public final boolean isWithDot() {
		return withDot;
	}

	// Frequent use

	public static StyleSignatureBasic activity() {
		return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
	}

	public static StyleSignatureBasic activityDiamond() {
		return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
	}

	public static StyleSignatureBasic activityArrow() {
		return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.arrow);
	}

}
