// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.svek;

import java.util.Collection;

import net.sourceforge.plantuml.abel.EntityPosition;
import net.sourceforge.plantuml.klimt.geom.Rankdir;
import net.sourceforge.plantuml.klimt.geom.RectangleArea;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class FrontierCalculator {

	private static final double DELTA = 3 * EntityPosition.RADIUS;
	private RectangleArea core;
	private final RectangleArea initial;

	public FrontierCalculator(RectangleArea initial, Collection<RectangleArea> insides, Collection<XPoint2D> points,
			Rankdir rankdir) {
		this.initial = initial;
		for (RectangleArea in : insides)
			if (core == null)
				core = in;
			else
				core = core.merge(in);

		if (core == null) {
			final XPoint2D center = initial.getPointCenter();
			core = new RectangleArea(center.getX() - 1, center.getY() - 1, center.getX() + 1, center.getY() + 1);
		}
		for (XPoint2D p : points)
			core = core.merge(p);

		boolean touchMinX = false;
		boolean touchMaxX = false;
		boolean touchMinY = false;
		boolean touchMaxY = false;
		for (XPoint2D p : points) {
			if (p.getX() == core.getMinX())
				touchMinX = true;

			if (p.getX() == core.getMaxX())
				touchMaxX = true;

			if (p.getY() == core.getMinY())
				touchMinY = true;

			if (p.getY() == core.getMaxY())
				touchMaxY = true;

		}
		if (touchMinX == false)
			core = core.withMinX(initial.getMinX());

		if (touchMaxX == false)
			core = core.withMaxX(initial.getMaxX());

		if (touchMinY == false)
			core = core.withMinY(initial.getMinY());

		if (touchMaxY == false)
			core = core.withMaxY(initial.getMaxY());

		boolean pushMinX = false;
		boolean pushMaxX = false;
		boolean pushMinY = false;
		boolean pushMaxY = false;
		for (XPoint2D p : points) {
			if (p.getY() == core.getMinY() || p.getY() == core.getMaxY()) {
				if (Math.abs(p.getX() - core.getMaxX()) < DELTA)
					pushMaxX = true;

				if (Math.abs(p.getX() - core.getMinX()) < DELTA)
					pushMinX = true;

			}
			if (p.getX() == core.getMinX() || p.getX() == core.getMaxX()) {
				if (Math.abs(p.getY() - core.getMaxY()) < DELTA)
					pushMaxY = true;

				if (Math.abs(p.getY() - core.getMinY()) < DELTA)
					pushMinY = true;

			}
		}
		for (XPoint2D p : points) {
			if (rankdir == Rankdir.LEFT_TO_RIGHT) {
				if (p.getX() == core.getMinX() && (p.getY() == core.getMinY() || p.getY() == core.getMaxY()))
					pushMinX = false;

				if (p.getX() == core.getMaxX() && (p.getY() == core.getMinY() || p.getY() == core.getMaxY()))
					pushMaxX = false;
			} else {

				if (p.getY() == core.getMinY() && (p.getX() == core.getMinX() || p.getX() == core.getMaxX()))
					pushMinY = false;

				if (p.getY() == core.getMaxY() && (p.getX() == core.getMinX() || p.getX() == core.getMaxX()))
					pushMaxY = false;
			}

		}
		if (pushMaxX)
			core = core.addMaxX(DELTA);

		if (pushMinX)
			core = core.addMinX(-DELTA);

		if (pushMaxY)
			core = core.addMaxY(DELTA);

		if (pushMinY)
			core = core.addMinY(-DELTA);

	}

	public RectangleArea getSuggestedPosition() {
		return core;
	}

	public void ensureMinWidth(double minWidth) {
		final double delta = core.getMaxX() - core.getMinX() - minWidth;
		if (delta < 0) {
			double newMinX = core.getMinX() + delta / 2;
			double newMaxX = core.getMaxX() - delta / 2;
			final double error = newMinX - initial.getMinX();
			if (error < 0) {
				newMinX -= error;
				newMaxX -= error;
			}
			core = core.withMinX(newMinX);
			core = core.withMaxX(newMaxX);
		}
	}

}
