// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.text.BackSlash;
import net.sourceforge.plantuml.text.StringLocated;

public class BlocLines implements Iterable<StringLocated> {
	// ::remove file when __HAXE__

	private List<StringLocated> lines;

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder();
		for (StringLocated line : lines) {
			sb.append("<<<");
			sb.append(line);
			sb.append(">>>");
		}
		return sb.toString();
	}

	public static BlocLines load(SFile f, LineLocation location) throws IOException {
		final BufferedReader br = f.openBufferedReader();
		if (br == null)
			return null;

		return loadInternal(br, location);
	}

	public static BlocLines load(InputStream is, LineLocation location) throws IOException {
		final BufferedReader br = new BufferedReader(new InputStreamReader(is));
		return loadInternal(br, location);
	}

	public static BlocLines from(List<StringLocated> lines) {
		return new BlocLines(lines);
	}

	private static BlocLines loadInternal(final BufferedReader br, LineLocation location) throws IOException {
		final List<StringLocated> result = new ArrayList<>();
		String s;
		try {
			while ((s = br.readLine()) != null)
				result.add(new StringLocated(s, location));
		} finally {
			br.close();
		}
		return new BlocLines(result);
	}

	private BlocLines(List<StringLocated> lines) {
		this.lines = Collections.unmodifiableList(lines);
	}

	public Display toDisplay() throws NoSuchColorException {
		return Display.createFoo(lines);
	}

	public static BlocLines single(StringLocated single) {
		final List<StringLocated> result = new ArrayList<>();
		result.add(single);
		return new BlocLines(result);
	}

	public static BlocLines singleString(String single) {
		final List<StringLocated> result = new ArrayList<>();
		result.add(new StringLocated(single, null));
		return new BlocLines(result);
	}

	public static BlocLines fromArray(String[] array) {
		final List<StringLocated> result = new ArrayList<>();
		for (String single : array)
			result.add(new StringLocated(single, null));

		return new BlocLines(result);
	}

	public static BlocLines getWithNewlines(String s) {
		final List<StringLocated> result = new ArrayList<>();
		for (String cs : BackSlash.getWithNewlines(s))
			result.add(new StringLocated(cs, null));

		return new BlocLines(result);
	}

	public static BlocLines create() {
		return new BlocLines(new ArrayList<StringLocated>());
	}

	public BlocLines add(StringLocated s) {
		final List<StringLocated> copy = new ArrayList<>(lines);
		copy.add(s);
		return new BlocLines(copy);
	}

	public BlocLines addString(String s) {
		final List<StringLocated> copy = new ArrayList<>(lines);
		copy.add(new StringLocated(s, null));
		return new BlocLines(copy);
	}

	public List<String> getLinesAsStringForSprite() {
		final List<String> result = new ArrayList<>();
		for (StringLocated s : lines)
			result.add(s.getString());

		return result;
	}

	public int size() {
		return lines.size();
	}

	public StringLocated getAt(int i) {
		return lines.get(i);
	}

	public StringLocated getFirst() {
		if (lines.size() == 0)
			return null;

		return lines.get(0);
	}

	public StringLocated getLast() {
		return lines.get(lines.size() - 1);
	}

	public BlocLines cleanList(MultilinesStrategy strategy) {
		final List<StringLocated> copy = new ArrayList<>(lines);
		strategy.cleanList(copy);
		return new BlocLines(copy);
	}

	public BlocLines trim() {
		final List<StringLocated> copy = new ArrayList<>(lines);
		for (int i = 0; i < copy.size(); i++) {
			final StringLocated s = copy.get(i);
			copy.set(i, s.getTrimmed());
		}
		return new BlocLines(copy);
	}

	public BlocLines removeEmptyLines() {
		final List<StringLocated> copy = new ArrayList<>(lines);
		for (final Iterator<StringLocated> it = copy.iterator(); it.hasNext();)
			if (it.next().getString().length() == 0)
				it.remove();

		return new BlocLines(copy);
	}

//	public BlocLines trimRight() {
//		final List<StringLocated> copy = new ArrayList<>(lines);
//		for (int i = 0; i < copy.size(); i++) {
//			final StringLocated s = copy.get(i);
//			copy.set(i, s.getTrimmedRight());
//		}
//		return new BlocLines(copy);
//	}

	public BlocLines removeEmptyColumns() {
		if (firstColumnRemovable(lines) == false)
			return this;

		final List<StringLocated> copy = new ArrayList<>(lines);
		do {
			for (int i = 0; i < copy.size(); i++) {
				final StringLocated s = copy.get(i);
				if (s.getString().length() > 0)
					copy.set(i, s.substring(1, s.getString().length()));

			}
		} while (firstColumnRemovable(copy));
		return new BlocLines(copy);
	}

	private static boolean firstColumnRemovable(List<StringLocated> data) {
		boolean allEmpty = true;
		for (StringLocated s : data) {
			if (s.getString().length() == 0)
				continue;

			allEmpty = false;
			final char c = s.getString().charAt(0);
			if (c != ' ' && c != '\t')
				return false;

		}
		return allEmpty == false;
	}

	public char getLastChar() {
		final StringLocated s = lines.get(lines.size() - 1);
		return s.getString().charAt(s.getString().length() - 1);
	}

	public BlocLines removeStartingAndEnding(String data, int removeAtEnd) {
		if (lines.size() == 0)
			return this;

		final List<StringLocated> copy = new ArrayList<>(lines);
		copy.set(0, new StringLocated(data, null));
		final int n = copy.size() - 1;
		final StringLocated s = copy.get(n);
		copy.set(n, s.substring(0, s.getString().length() - removeAtEnd));
		return new BlocLines(copy);
	}

	public BlocLines overrideLastLine(String last) {
		if (lines.size() == 0)
			return this;

		final List<StringLocated> copy = new ArrayList<>(lines);
		final int n = copy.size() - 1;
		final StringLocated currentLast = copy.get(n);
		copy.set(n, new StringLocated(last, currentLast.getLocation()));
		return new BlocLines(copy);
	}

	public BlocLines toSingleLineWithHiddenNewLine() {
		final StringBuilder sb = new StringBuilder();
		for (StringLocated line : lines) {
			sb.append(line.getString());
			sb.append(BackSlash.hiddenNewLine());
		}
		return singleString(sb.substring(0, sb.length() - 1).toString());
	}

	public BlocLines trimSmart(int referenceLine) {
		if (lines.size() <= referenceLine)
			return this;

		final List<StringLocated> copy = new ArrayList<>(lines);
		final int nbStartingSpace = nbStartingSpace(copy.get(referenceLine).getString());
		for (int i = referenceLine; i < copy.size(); i++) {
			final StringLocated s = copy.get(i);
			copy.set(i, removeStartingSpaces(s, nbStartingSpace));
		}
		return new BlocLines(copy);
	}

	private static int nbStartingSpace(CharSequence s) {
		int nb = 0;
		while (nb < s.length() && isSpaceOrTab(s.charAt(nb)))
			nb++;

		return nb;
	}

	private static boolean isSpaceOrTab(char c) {
		return c == ' ' || c == '\t';
	}

	private static StringLocated removeStartingSpaces(StringLocated arg, int nbStartingSpace) {
		if (arg.getString().length() == 0)
			return arg;

		int i = 0;
		while (i < nbStartingSpace && i < arg.getString().length() && isSpaceOrTab(arg.getString().charAt(i)))
			i++;

		if (i == 0)
			return arg;

		return arg.substring(i, arg.getString().length());
	}

	public BlocLines subExtract(int margeStart, int margeEnd) {
		List<StringLocated> copy = new ArrayList<>(lines);
		copy = copy.subList(margeStart, copy.size() - margeEnd);
		return new BlocLines(copy);
	}

	public BlocLines subList(int start, int end) {
		return new BlocLines(lines.subList(start, end));
	}

	public Iterator<StringLocated> iterator() {
		return lines.iterator();
	}

	public BlocLines eventuallyMoveBracket() {
		if (size() < 2)
			return this;

		final String first = getFirst().getTrimmed().getString();
		final String second = getAt(1).getTrimmed().getString();
		if (first.endsWith("{") == false && second.equals("{")) {
			final StringLocated vline = getFirst().append(" {");
			final List<StringLocated> result = new ArrayList<>();
			result.add(vline);
			result.addAll(this.lines.subList(2, this.lines.size()));
			return new BlocLines(result);
		}
		return this;
	}

	public BlocLines eventuallyMoveAllEmptyBracket() {
		final List<StringLocated> result = new ArrayList<>();
		for (StringLocated line : lines)
			if (line.getTrimmed().toString().equals("{")) {
				if (result.size() > 0) {
					final int pos = result.size() - 1;
					StringLocated last = result.get(pos);
					result.set(pos, last.append(" {"));
				}
			} else {
				result.add(line);
			}

		return new BlocLines(result);
	}

	public BlocLines removeFewChars(int nb) {
		final List<StringLocated> result = new ArrayList<>();
		result.add(getFirst().substring(nb).getTrimmed());
		result.addAll(this.lines.subList(1, this.lines.size() - 1));
		final StringLocated last = getLast();
		result.add(last.substring(0, last.length() - nb).getTrimmed());
		return new BlocLines(result);
	}

	public CharInspector inspector() {
		return new CharInspectorImpl(this, false);
	}

	public CharInspector inspectorWithNewlines() {
		return new CharInspectorImpl(this, true);
	}

}
