// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.windowsdot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import net.sourceforge.plantuml.brotli.BrotliInputStream;
import net.sourceforge.plantuml.log.Logme;

public final class WindowsDotArchive {
    // ::remove folder when __HAXE__
	// ::remove folder when __CORE__

	private static WindowsDotArchive singleton = null;

	private Boolean isThereArchive;
	private File exe;

	private WindowsDotArchive() {

	}

	public final synchronized static WindowsDotArchive getInstance() {
		if (singleton == null)
			singleton = new WindowsDotArchive();

		return singleton;
	}

	final static public String readString(InputStream is) throws IOException {
		int len = readByte(is);
		final StringBuilder sb = new StringBuilder(len);
		for (int i = 0; i < len; i++) {
			sb.append((char) readByte(is));

		}
		return sb.toString();
	}

	final static public int readNumber(InputStream is) throws IOException {
		int result = readByte(is);
		result = result * 256 + readByte(is);
		result = result * 256 + readByte(is);
		return result;
	}

	private static int readByte(InputStream is) throws IOException {
		return is.read();
	}

	private static void extract(File dir) throws IOException {
		final InputStream raw = WindowsDotArchive.class.getResourceAsStream("graphviz.dat");
		try (final BrotliInputStream is = new BrotliInputStream(raw)) {
			while (true) {
				final String name = readString(is);
				if (name.length() == 0)
					break;
				final int size = readNumber(is);
				final File fileout = new File(dir, name);

				if (fileout.exists())
					for (int i = 0; i < size; i++)
						is.read();
				else
					try (final OutputStream fos = new BufferedOutputStream(new FileOutputStream(fileout))) {
						for (int i = 0; i < size; i++)
							fos.write(is.read());
					}
			}
		}
	}

	public synchronized boolean isThereArchive() {
		if (isThereArchive == null)
			try (InputStream raw = WindowsDotArchive.class.getResourceAsStream("graphviz.dat")) {
				isThereArchive = raw != null;
			} catch (Exception e) {
				isThereArchive = false;
			}
		return isThereArchive;
	}

	public synchronized File getWindowsExeLite() {
		if (isThereArchive() == false)
			return null;

		if (exe == null) {
			final File tmp = new File(System.getProperty("java.io.tmpdir"), "_graphviz");
			try {
				tmp.mkdirs();
				extract(tmp);
			} catch (IOException e) {
				Logme.error(e);
			}
			exe = new File(tmp, "dot.exe");
		}
		return exe;
	}

}
