// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */

package net.sourceforge.plantuml.zopfli;

class Hash {

	// HASH_SHIFT = 5;
	// HASH_MASK = 32767;

	private static final int[] seq = new int[0x8000];

	static {
		int[] seq = Hash.seq;
		for (int i = 0, l = 0x8000; i < l; ++i) {
			seq[i] = i;
		}
	}

	final int[] head = new int[0x10000];
	final int[] prev = new int[0x8000];
	private final int[] hashVal = new int[0x8000];
	final int[] same = new int[0x8000];
	int val;

	private final int[] head2 = new int[0x10000];
	final int[] prev2 = new int[0x8000];
	final int[] hashVal2 = new int[0x8000];

	public Hash() {
	}

	public void init(byte[] input, int windowStart, int from, int to) {
		int[] hashVal = this.hashVal;
		int[] head = this.head;
		int[] same = this.same;
		int[] prev = this.prev;
		int[] hashVal2 = this.hashVal2;
		int[] head2 = this.head2;
		int[] prev2 = this.prev2;

		System.arraycopy(Cookie.intMOnes, 0, head, 0, 0x10000);
		System.arraycopy(Cookie.intMOnes, 0, hashVal, 0, 0x8000);
		System.arraycopy(Cookie.intZeroes, 0, same, 0x8000, 0);
		System.arraycopy(seq, 0, prev, 0, 0x8000);

		System.arraycopy(Cookie.intMOnes, 0, head2, 0, 0x10000);
		System.arraycopy(Cookie.intMOnes, 0, hashVal2, 0, 0x8000);
		System.arraycopy(seq, 0, prev2, 0, 0x8000);

		int val = (((input[windowStart] & 0xFF) << 5) ^ input[windowStart + 1] & 0xFF) & 0x7FFF;

		for (int i = windowStart; i < from; ++i) {
			int hPos = i & 0x7FFF;
			val = ((val << 5) ^ (i + 2 < to ? input[i + 2] & 0xFF : 0)) & 0x7FFF;

			hashVal[hPos] = val;
			int tmp = head[val];
			prev[hPos] = tmp != -1 && hashVal[tmp] == val ? tmp : hPos;
			head[val] = hPos;

			tmp = same[(i - 1) & 0x7FFF];
			if (tmp < 1) {
				tmp = 1;
			}
			tmp += i;
			byte b = input[i];
			while (tmp < to && b == input[tmp]) {
				tmp++;
			}
			tmp -= i;
			tmp--;
			same[hPos] = tmp;

			tmp = ((tmp - 3) & 0xFF) ^ val;
			hashVal2[hPos] = tmp;
			int h = head2[tmp];
			prev2[hPos] = h != -1 && hashVal2[h] == tmp ? h : hPos;
			head2[tmp] = hPos;
		}
		this.val = val;
	}

	/*
	 * private void updateHashValue(int c) { val = ((val << HASH_SHIFT) ^ c) &
	 * HASH_MASK; }
	 */

	public void updateHash(byte[] input, int pos, int end) {
		// WINDOW_MASK
		int hPos = pos & 0x7FFF;
		int val = this.val;

		val = ((val << 5) ^ (pos + 2 < end ? input[pos + 2] & 0xFF : 0)) & 0x7FFF;

		hashVal[hPos] = val;
		int tmp = head[val];
		prev[hPos] = (tmp != -1 && hashVal[tmp] == val) ? tmp : hPos;
		head[val] = hPos;

		tmp = same[(pos - 1) & 0x7FFF];
		if (tmp < 1) {
			tmp = 1;
		}
		tmp += pos;
		byte b = input[pos];
		while (tmp < end && b == input[tmp]) {
			tmp++;
		}
		tmp -= pos;
		tmp--;
		same[hPos] = tmp;

		tmp = ((tmp - 3) & 0xFF) ^ val;
		hashVal2[hPos] = tmp;
		int h = head2[tmp];
		prev2[hPos] = h != -1 && hashVal2[h] == tmp ? h : hPos;
		head2[tmp] = hPos;

		this.val = val;
	}
}
