// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */

package net.sourceforge.plantuml.zopfli;

import net.sourceforge.plantuml.zopfli.Cookie.Node;

class Katajainen {
    // ::remove folder when __HAXE__

	static void lengthLimitedCodeLengths(Cookie cookie, int[] frequencies, int maxBits, int[] bitLengths) {
		cookie.resetPool();
		int n = frequencies.length;
		int nn = 0;
		Node[] leaves = cookie.leaves1;
		for (int i = 0; i < n; i++) {
			if (frequencies[i] != 0) {
				leaves[nn] = cookie.node(frequencies[i], i, null);
				nn++;
			}
		}

		if (nn == 0) {
			return;
		}
		if (nn == 1) {
			bitLengths[leaves[0].count] = 1;
			return;
		}

		Node[] leaves2 = cookie.leaves2;
		System.arraycopy(leaves, 0, leaves2, 0, nn);
		sort(leaves2, leaves, 0, nn);

		Node[] list0 = cookie.list0;
		Node node0 = cookie.node(leaves[0].weight, 1, null);

		Node[] list1 = cookie.list1;
		Node node1 = cookie.node(leaves[1].weight, 2, null);

		for (int i = 0; i < maxBits; ++i) {
			list0[i] = node0;
			list1[i] = node1;
		}

		int numBoundaryPmRuns = 2 * nn - 4;
		for (int i = 0; i < numBoundaryPmRuns; i++) {
			boolean last = i == numBoundaryPmRuns - 1;
			boundaryPm(cookie, leaves, list0, list1, nn, maxBits - 1, last);
		}

		for (Node node = list1[maxBits - 1]; node != null; node = node.tail) {
			for (int i = node.count - 1; i >= 0; --i) {
				bitLengths[leaves[i].count]++;
			}
		}
	}

	private static void boundaryPm(Cookie cookie, Node[] leaves, Node[] list0, Node[] list1, int numSymbols, int index,
			boolean last) {
		int lastCount = list1[index].count;

		if (index == 0 && lastCount >= numSymbols) {
			return;
		}

		list0[index] = list1[index];

		if (index == 0) {
			list1[index] = cookie.node(leaves[lastCount].weight, lastCount + 1, null);
		} else {
			int sum = list0[index - 1].weight + list1[index - 1].weight;
			if (lastCount < numSymbols && sum > leaves[lastCount].weight) {
				list1[index] = cookie.node(leaves[lastCount].weight, lastCount + 1, list1[index].tail);
			} else {
				list1[index] = cookie.node(sum, lastCount, list1[index - 1]);
				if (!last) {
					boundaryPm(cookie, leaves, list0, list1, numSymbols, index - 1, false);
					boundaryPm(cookie, leaves, list0, list1, numSymbols, index - 1, false);
				}
			}
		}
	}

	private static void sort(Node[] src, Node[] dest, int low, int high) {
		int length = high - low;

		if (length < 7) {
			for (int i = low + 1; i < high; i++)
				for (int j = i, k = i - 1; j > low && (dest[k].weight > dest[j].weight); --j, --k) {
					Node t = dest[j];
					dest[j] = dest[k];
					dest[k] = t;
				}
			return;
		}

		int mid = (low + high) >>> 1;
		sort(dest, src, low, mid);
		sort(dest, src, mid, high);

		for (int i = low, p = low, q = mid; i < high; i++) {
			if (q >= high || p < mid && (src[p].weight <= src[q].weight))
				dest[i] = src[p++];
			else
				dest[i] = src[q++];
		}
	}
}
