// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */

package net.sourceforge.plantuml.zopfli;

class LongestMatchCache {

	private final static int CACHE_LENGTH = 8;

	public final char[] length;
	public final char[] dist;
	private final char[] subLenPos;
	private final byte[] subLenLen;

	LongestMatchCache(int maxBlockSize) {
		length = new char[maxBlockSize];
		dist = new char[maxBlockSize];
		subLenPos = new char[CACHE_LENGTH * maxBlockSize];
		subLenLen = new byte[CACHE_LENGTH * maxBlockSize];
	}

	void init(int blockSize) {
		Cookie.fill0(dist, blockSize);
		int n = blockSize << 3; // * CACHE_LENGTH
		char[] subLenPos = this.subLenPos;
		byte[] subLenLen = this.subLenLen;
		char[] length = this.length;

		char[] charZeroes = Cookie.charZeroes;
		byte[] byteZeroes = Cookie.byteZeroes;
		char[] charOnes = Cookie.charOnes;

		int i = 0;
		while (i < n) {
			int j = i + 65536;
			if (j > n) {
				j = n;
			}
			int l = j - i;
			System.arraycopy(byteZeroes, 0, subLenLen, i, l);
			System.arraycopy(charZeroes, 0, subLenPos, i, l);
			i = j;
		}

		i = 0;
		while (i < blockSize) {
			int j = i + 65536;
			if (j > blockSize) {
				j = blockSize;
			}
			int l = j - i;
			System.arraycopy(charOnes, 0, length, i, l);
			System.arraycopy(charZeroes, 0, subLenPos, i, l);
			i = j;
		}
	}

	void subLenToCache(char[] input, int pos, int len) {
		if (len < 3) {
			return;
		}

		int bestLength = 0;
		int j = pos * CACHE_LENGTH;
		int last = j + CACHE_LENGTH - 1;
		for (int i = 3; i <= len; ++i) {
			if (i == len || input[i] != input[i + 1]) {
				subLenPos[j] = input[i];
				subLenLen[j] = (byte) (i - 3);
				bestLength = i;
				j++;
				if (j > last) {
					break;
				}
			}
		}
		if (j <= last) {
			subLenLen[last] = (byte) (bestLength - 3);
		}
	}

	void cacheToSubLen(int pos, int len, char[] output) {
		if (len < 3) {
			return;
		}

		int maxLength = maxCachedSubLen(pos);
		int prevLength = 0;
		int j = CACHE_LENGTH * pos;
		int last = j + CACHE_LENGTH;
		for (; j < last; ++j) {
			int cLen = (subLenLen[j] & 0xFF) + 3;
			char dist = subLenPos[j];
			for (int i = prevLength; i <= cLen; ++i) {
				output[i] = dist;
			}
			if (cLen == maxLength) {
				break;
			}
			prevLength = cLen + 1;
		}
	}

	int maxCachedSubLen(int pos) {
		pos = pos * CACHE_LENGTH;
		if (subLenPos[pos] == 0) {
			return 0;
		}
		return (subLenLen[pos + CACHE_LENGTH - 1] & 0xFF) + 3;
	}
}
