/*
 * Decompiled with CFR 0.152.
 */
package no.sparebank1.turbo;

import java.util.List;
import java.util.Map;
import no.sparebank1.turbo.Checksums;
import org.codehaus.plexus.logging.Logger;

public class ArtifactAnalyzer {
    private final Checksums checksums;
    private final Logger logger;

    public ArtifactAnalyzer(Checksums checksums, Logger logger) {
        this.logger = logger;
        this.checksums = checksums;
    }

    public boolean shallBuild(String m2repository, List<String> sourcefiles, String groupId, String artifactId, String version, String packaging, String alwaysBuildModules) {
        if (sourcefiles.isEmpty()) {
            System.out.println("We did not find any source files for " + artifactId);
            return true;
        }
        if (alwaysBuildModules.contains(artifactId)) {
            return true;
        }
        Map<String, String> currentChecksums = this.checksums.createChecksums(sourcefiles, groupId, artifactId, version);
        Map artifactChecksums = this.checksums.readChecksums(m2repository, groupId, artifactId, version);
        if (!currentChecksums.isEmpty() && artifactChecksums.isEmpty()) {
            this.logger.info("We did not find any checksums for " + artifactId);
            return true;
        }
        if (!currentChecksums.equals(artifactChecksums)) {
            this.logger.info("Checksums have changed for " + artifactId);
            return true;
        }
        return false;
    }

    String getArtifactPath(String m2Repository, String groupId, String artifactId, String version) {
        StringBuilder path = new StringBuilder(m2Repository);
        path.append("/");
        path.append(groupId.replace('.', '/'));
        path.append("/");
        path.append(artifactId);
        path.append("/");
        path.append(version);
        return path.toString();
    }

    String getArtifactFilename(String m2Repository, String groupId, String artifactId, String version, String packaging) {
        String artifactPath = this.getArtifactPath(m2Repository, groupId, artifactId, version);
        StringBuilder filename = new StringBuilder(artifactPath);
        filename.append("/");
        filename.append(artifactId);
        filename.append("-");
        filename.append(version);
        filename.append(".");
        filename.append(packaging);
        return filename.toString();
    }
}

