/*
 * Decompiled with CFR 0.152.
 */
package no.sparebank1.turbo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import no.sparebank1.turbo.MD5Checksum;

public class Checksums {
    public Map<String, String> createChecksums(List<String> sourceFiles, String groupId, String artifactId, String version) {
        Map<String, String> checksums = sourceFiles.stream().collect(Collectors.toMap(file -> file, file -> "" + MD5Checksum.getMD5Checksum(file)));
        return checksums;
    }

    public String writeChecksums(String m2Repository, Map<String, String> checksums, String groupId, String artifactId, String version) {
        String path = this.getChecksumsPath(m2Repository, groupId, artifactId, version);
        new File(path).mkdirs();
        String filename = this.getChecksumsFilename(m2Repository, groupId, artifactId, version);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(checksums);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return path;
    }

    public String createAndWriteChecksums(String m2Repository, List<String> sourceFiles, String groupId, String artifactId, String version) {
        Map<String, String> currentChecksums = this.createChecksums(sourceFiles, groupId, artifactId, version);
        return this.writeChecksums(m2Repository, currentChecksums, groupId, artifactId, version);
    }

    String getChecksumsFilename(String m2Repository, String groupId, String artifactId, String version) {
        StringBuffer path = new StringBuffer(this.getChecksumsPath(m2Repository, groupId, artifactId, version));
        path.append("/");
        path.append(artifactId);
        path.append("-");
        path.append(version);
        path.append("-");
        path.append("checksums.ser");
        return path.toString();
    }

    private String getChecksumsPath(String m2Repository, String groupId, String artifactId, String version) {
        StringBuilder path = new StringBuilder(m2Repository);
        path.append("/");
        path.append(groupId.replace('.', '/'));
        path.append("/");
        path.append(artifactId);
        path.append("/");
        path.append(version);
        return path.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Map readChecksums(String m2repository, String groupId, String artifactId, String version) {
        String chekcksumsFilename = this.getChecksumsFilename(m2repository, groupId, artifactId, version);
        Map checksums = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(chekcksumsFilename);
        }
        catch (FileNotFoundException e) {
            return Collections.emptyMap();
        }
        try (ObjectInputStream ois = new ObjectInputStream(fis);){
            try {
                checksums = (Map)ois.readObject();
                return checksums;
            }
            catch (ClassNotFoundException e) {
                Map map = Collections.emptyMap();
                ois.close();
                return map;
            }
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }
}

