/*
 * Decompiled with CFR 0.152.
 */
package no.sparebank1.turbo.extension;

import java.util.List;
import no.sparebank1.turbo.ArtifactAnalyzer;
import no.sparebank1.turbo.Checksums;
import no.sparebank1.turbo.ProjectsAnalyzer;
import no.sparebank1.turbo.SourceFileFinder;
import no.sparebank1.turbo.TurboConfig;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class TurboBuildWrapper
extends AbstractMavenLifecycleParticipant {
    private TurboConfig config;
    @Requirement
    private Logger logger;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            this.config = new TurboConfig(session);
            if (this.config.enabled) {
                ProjectsAnalyzer projectsAnalyzer = new ProjectsAnalyzer(new ArtifactAnalyzer(new Checksums(), this.logger), new SourceFileFinder());
                this.logTurboPluginInfoMessage(this.logger, session.getGoals());
                List projects = session.getProjects();
                List<MavenProject> projectsToBuild = projectsAnalyzer.calculateProjectsToBuild(this.config.m2Repository, projects, session.getProjectDependencyGraph(), this.config.ignoreChangesInFiles, this.config.alwaysBuildModules);
                session.setProjects(projectsToBuild);
                projectsToBuild.forEach(project -> this.logger.info("Building: " + project.getName()));
                if (projectsToBuild.isEmpty()) {
                    session.setProjects(projects.subList(0, 1));
                    session.getGoals().clear();
                    session.getGoals().add("validate");
                    this.logger.info("No new code or config, so we are done.\n");
                }
            } else {
                this.logger.info("Turbo build is disabled.");
            }
        }
        catch (Exception e) {
            System.out.println("Exception during turbo execution in afterProjectsRead, so running regular build. Exception was " + e.getMessage());
        }
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        try {
            if (this.config.enabled) {
                List projects = session.getProjects();
                projects.forEach(project -> {
                    if (session.getResult().getBuildSummary(project).toString().toLowerCase().contains("success")) {
                        List<String> sourceFiles = new SourceFileFinder().getSourceFiles(project.getBasedir().getAbsolutePath(), this.config.ignoreChangesInFiles);
                        new Checksums().createAndWriteChecksums(this.config.m2Repository, sourceFiles, project.getGroupId(), project.getArtifactId(), project.getVersion());
                    }
                });
            } else {
                this.logger.info("Turbo build is disabled.");
            }
        }
        catch (Exception e) {
            System.out.println("Exception during turbo execution in afterSessionEnd, so running regular build. Exception was " + e.getMessage());
        }
    }

    private void logTurboPluginInfoMessage(Logger logger, List<String> goals) {
        logger.info("Starting Turbo pre build hook.\n\nIf you want to run without it, run e.g. mvn clean install -Dturbo.enabled=false\n");
        if (goals.size() == 1 && goals.get(0).equals("clean")) {
            logger.info("You are running mvn clean\n\nIf you want to clean absolutely all projects, run mvn clean -Dturbo.enabled=false\n");
        }
    }
}

