/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.util;

import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.utils.HashProcessor;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

public class HashUtil {
    private static final HashProcessor HASH_PROCESSOR = PasswordMaskingUtil.getHashProcessor();

    public static String tryHash(ActionContext context, String plaintext) {
        try {
            String hash = HASH_PROCESSOR.hash(plaintext);
            return hash;
        }
        catch (Exception e) {
            context.err.println("Warning: Failed to calculate hash value for password using " + HASH_PROCESSOR);
            context.err.println("Reason: " + e.getMessage());
            e.printStackTrace();
            return plaintext;
        }
    }
}

