/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ideaplugin.frames;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;
import org.apache.ideaplugin.bean.ArchiveBean;

public class ClassFileLocationPage
extends WizardPanel {
    private JTextField txtClassDir;
    private JButton butSelect;
    private JCheckBox chkBoxIncludeClass;
    private JCheckBox chkBoxArchiveType;
    private JButton btnHint;
    private JTextArea txaHint;
    private boolean flag = false;
    private String hint = ":";
    private ArchiveBean archiveBean;
    public final JFileChooser fileChooser = new JFileChooser();
    private File file;

    public ClassFileLocationPage(WizardComponents wizardComponents, ArchiveBean archiveBean) {
        super(wizardComponents, "Axis2 Idea Plugin Service Archiver Creator Wizards");
        this.setPanelTopTitle("Service Archiver");
        this.setPanelBottomTitle("Welcome to Axis2 Service Archive Wizard.Insert the class files and select the service type. ");
        this.archiveBean = archiveBean;
        this.init();
    }

    private void init() {
        this.txaHint = new JTextArea();
        this.txaHint.setBorder(null);
        this.txaHint.setFocusable(false);
        this.txaHint.setLineWrap(true);
        this.txaHint.setWrapStyleWord(true);
        this.txaHint.setOpaque(false);
        this.btnHint = new JButton("Hint >>");
        this.btnHint.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.txtClassDir = new JTextField();
        this.butSelect = new JButton("Browse..");
        this.chkBoxIncludeClass = new JCheckBox("include .class file only");
        this.chkBoxArchiveType = new JCheckBox("Select for Service Group Archive");
        this.setBackButtonEnabled(true);
        this.setFinishButtonEnabled(false);
        this.setPageComplete(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Class file location"), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.txtClassDir, new GridBagConstraints(1, 0, -1, 1, 1.0, 0.0, 17, 2, new Insets(5, 1, 1, 1), 0, 0));
        this.txtClassDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassFileLocationPage.this.update();
            }
        });
        this.add((Component)this.butSelect, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 0, new Insets(5, 1, 1, 10), 0, 0));
        this.butSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassFileLocationPage.this.fileChooser.setFileSelectionMode(1);
                int returnVal = ClassFileLocationPage.this.fileChooser.showOpenDialog(ClassFileLocationPage.this.butSelect);
                if (returnVal == 0) {
                    ClassFileLocationPage.this.file = ClassFileLocationPage.this.fileChooser.getSelectedFile();
                    ClassFileLocationPage.this.fileChooser.setCurrentDirectory(ClassFileLocationPage.this.file);
                    ClassFileLocationPage.this.txtClassDir.setText(ClassFileLocationPage.this.file.getAbsolutePath());
                    ClassFileLocationPage.this.setPageComplete(true);
                    ClassFileLocationPage.this.setNextButtonEnabled(true);
                } else {
                    ClassFileLocationPage.this.txtClassDir.setText("");
                }
                ClassFileLocationPage.this.update();
            }
        });
        this.add((Component)this.chkBoxIncludeClass, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 1, 1), 0, 0));
        this.chkBoxIncludeClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassFileLocationPage.this.update();
            }
        });
        this.add((Component)this.btnHint, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.btnHint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassFileLocationPage.this.flag) {
                    ClassFileLocationPage.this.btnHint.setText("Hint >>");
                    ClassFileLocationPage.this.txaHint.setText("");
                    ClassFileLocationPage.this.flag = false;
                } else {
                    ClassFileLocationPage.this.btnHint.setText("Hint <<");
                    ClassFileLocationPage.this.txaHint.setText(ClassFileLocationPage.this.hint);
                    ClassFileLocationPage.this.flag = true;
                }
                ClassFileLocationPage.this.update();
            }
        });
        this.add((Component)this.txaHint, new GridBagConstraints(0, 3, 0, 1, 0.0, 1.0, 17, 1, new Insets(5, 10, 10, 10), 0, 0));
    }

    public void next() {
        this.switchPanel(8);
    }

    public void back() {
        this.switchPanel(0);
    }

    public void update() {
        this.fillBean();
    }

    private void fillBean() {
        if (!this.txtClassDir.getText().trim().equals("")) {
            this.archiveBean.setClassLoc(this.file);
            this.archiveBean.addClassLocation(this.file);
        }
        if (this.chkBoxIncludeClass.isSelected()) {
            this.archiveBean.setIncludeClass(true);
        } else {
            this.archiveBean.setIncludeClass(false);
        }
    }

    public int getPageType() {
        return 3;
    }
}

