/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ideaplugin.frames;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;
import org.apache.axis2.tools.idea.WSDLFileFilter;
import org.apache.ideaplugin.bean.ArchiveBean;

public class WSDLFileSelectionPage
extends WizardPanel {
    private JLabel lblWSDL;
    private JCheckBox chkBoxSkip;
    private JCheckBox chkBoxSelect;
    private JTextField txtWSDL;
    private JButton btnBrowse;
    private JButton btnHint;
    private JTextArea txaHint;
    private boolean flag = false;
    private String hint = "";
    private final JFileChooser fileChooser = new JFileChooser();
    private ArchiveBean archiveBean;

    public WSDLFileSelectionPage(WizardComponents wizardComponents, ArchiveBean archiveBean) {
        super(wizardComponents, "Axis2 Idea Plugin Service Archiver Creator Wizards");
        this.setPanelTopTitle("Service Archiver");
        this.setPanelBottomTitle("Add the WSDL file");
        this.archiveBean = archiveBean;
        this.init();
    }

    private void init() {
        this.txaHint = new JTextArea();
        this.txaHint.setBorder(null);
        this.txaHint.setFocusable(false);
        this.txaHint.setLineWrap(true);
        this.txaHint.setWrapStyleWord(true);
        this.txaHint.setOpaque(false);
        this.btnHint = new JButton("Hint >>");
        this.btnHint.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.lblWSDL = new JLabel("Select a WSDL file");
        this.chkBoxSkip = new JCheckBox("Skip WSDL", true);
        this.chkBoxSelect = new JCheckBox("Select WSDL", false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.chkBoxSkip);
        buttonGroup.add(this.chkBoxSelect);
        this.txtWSDL = new JTextField();
        this.btnBrowse = new JButton("Browse..");
        this.setBackButtonEnabled(true);
        this.setNextButtonEnabled(true);
        this.setFinishButtonEnabled(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.chkBoxSkip, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.chkBoxSkip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDLFileSelectionPage.this.update();
            }
        });
        this.add((Component)this.chkBoxSelect, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.chkBoxSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDLFileSelectionPage.this.update();
            }
        });
        this.add((Component)this.lblWSDL, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.txtWSDL, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.btnBrowse, new GridBagConstraints(2, 2, 1, 1, 0.1, 0.0, 10, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDLFileSelectionPage.this.browseWSDLFile();
                WSDLFileSelectionPage.this.checkWSDLFile();
                WSDLFileSelectionPage.this.update();
            }
        });
        this.add((Component)this.btnHint, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.btnHint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WSDLFileSelectionPage.this.flag) {
                    WSDLFileSelectionPage.this.btnHint.setText("Hint >>");
                    WSDLFileSelectionPage.this.txaHint.setText("");
                    WSDLFileSelectionPage.this.flag = false;
                } else {
                    WSDLFileSelectionPage.this.btnHint.setText("Hint <<");
                    WSDLFileSelectionPage.this.txaHint.setText(WSDLFileSelectionPage.this.hint);
                    WSDLFileSelectionPage.this.flag = true;
                }
                WSDLFileSelectionPage.this.update();
            }
        });
        this.add((Component)this.txaHint, new GridBagConstraints(0, 4, 0, 1, 0.1, 1.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
    }

    public void back() {
        this.switchPanel(7);
    }

    public void next() {
        this.switchPanel(9);
    }

    public void update() {
        this.setChangeEnabled();
        this.fillBean();
        this.setPageComplete(true);
        this.setBackButtonEnabled(true);
        this.setNextButtonEnabled(true);
    }

    public int getPageType() {
        return 3;
    }

    private void setChangeEnabled() {
        if (this.chkBoxSkip.isSelected()) {
            this.lblWSDL.setEnabled(false);
            this.txtWSDL.setEnabled(false);
            this.btnBrowse.setEnabled(false);
        } else {
            this.lblWSDL.setEnabled(true);
            this.txtWSDL.setEnabled(true);
            this.btnBrowse.setEnabled(true);
        }
    }

    private void fillBean() {
        if (this.chkBoxSelect.isSelected() && !this.txtWSDL.getText().equals("")) {
            this.archiveBean.addWsdls(new File(this.txtWSDL.getText()));
        }
    }

    private void checkWSDLFile() {
        if (this.txtWSDL.getText().equals("")) {
            try {
                WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                reader.readWSDL(this.txtWSDL.getText().trim());
            }
            catch (WSDLException e1) {
                this.txtWSDL.setText("");
                JOptionPane.showMessageDialog(this.btnBrowse, "The file selected is not a valid WSDLfile", "Axis2 ServiceArchieve creation", 0);
            }
        }
    }

    private void browseWSDLFile() {
        this.fileChooser.setFileFilter(new WSDLFileFilter());
        this.fileChooser.setCurrentDirectory(this.archiveBean.getClassLoc());
        int returnVal = this.fileChooser.showOpenDialog(this.btnBrowse);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.txtWSDL.setText(file.getAbsolutePath());
        }
    }
}

