/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.context.MessageContext;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;

public class RahasData {
    private MessageContext inMessageContext;
    private OMElement rstElement;
    private int version = -1;
    private String wstNs;
    private String requestType;
    private String tokenType;
    private int keysize = -1;
    private String computedKeyAlgo;
    private String keyType;
    private String appliesToAddress;
    private Principal principal;
    private X509Certificate clientCert;
    private byte[] ephmeralKey;
    private byte[] requestEntropy;
    private byte[] responseEntropy;
    private String addressingNs;
    private String soapNs;

    public RahasData(MessageContext inMessageContext) throws TrustException {
        this.inMessageContext = inMessageContext;
        this.processWSS4JSecurityResults();
        this.addressingNs = (String)this.inMessageContext.getProperty("WSAddressingVersion");
        this.rstElement = this.inMessageContext.getEnvelope().getBody().getFirstElement();
        this.soapNs = this.inMessageContext.getEnvelope().getNamespace().getNamespaceURI();
        this.wstNs = this.rstElement.getNamespace().getNamespaceURI();
        int ver = TrustUtil.getWSTVersion(this.wstNs);
        if (ver == -1) {
            throw new TrustException("InvalidRequest");
        }
        this.version = ver;
        this.processRequestType();
        this.processTokenType();
        this.processKeyType();
        this.processKeySize();
        this.processAppliesTo();
        this.processEntropy();
    }

    private void processWSS4JSecurityResults() throws TrustException {
        Vector results = (Vector)this.inMessageContext.getProperty("RECV_RESULTS");
        if (results == null) {
            throw new TrustException("RequestFailed");
        }
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                if (wser.getAction() == 2 && wser.getPrincipal() != null) {
                    this.clientCert = wser.getCertificate();
                    this.principal = wser.getPrincipal();
                    continue;
                }
                if (wser.getAction() != 1 || wser.getPrincipal() == null) continue;
                this.principal = wser.getPrincipal();
            }
        }
        if (this.principal == null) {
            throw new TrustException("RequestFailed");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processAppliesTo() throws TrustException {
        OMElement appliesToElem = this.rstElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "AppliesTo"));
        if (appliesToElem == null) return;
        OMElement eprElem = appliesToElem.getFirstElement();
        if (this.addressingNs == null) {
            this.addressingNs = eprElem.getNamespace().getNamespaceURI();
        }
        if (eprElem == null) throw new TrustException("invalidAppliesToElem");
        OMElement addrElem = eprElem.getFirstChildWithName(new QName(this.addressingNs, "Address"));
        if (addrElem == null || addrElem.getText() == null || "".equals(addrElem.getText().trim())) throw new TrustException("invalidAppliesToElem");
        this.appliesToAddress = addrElem.getText().trim();
    }

    private void processRequestType() throws TrustException {
        OMElement reqTypeElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "RequestType"));
        if (reqTypeElem == null || reqTypeElem.getText() == null || reqTypeElem.getText().trim().length() == 0) {
            throw new TrustException("InvalidRequest");
        }
        this.requestType = reqTypeElem.getText().trim();
    }

    private void processTokenType() {
        OMElement tokTypeElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "TokenType"));
        if (tokTypeElem != null && tokTypeElem.getText() != null && !"".equals(tokTypeElem.getText().trim())) {
            this.tokenType = tokTypeElem.getText().trim();
        }
    }

    private void processKeyType() {
        String text;
        OMElement keyTypeElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "KeyType"));
        if (keyTypeElem != null && (text = keyTypeElem.getText()) != null && !"".equals(text.trim())) {
            this.keyType = text.trim();
        }
    }

    private void processKeySize() throws TrustException {
        String text;
        OMElement keySizeElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "KeySize"));
        if (keySizeElem != null && (text = keySizeElem.getText()) != null && !"".equals(text.trim())) {
            try {
                this.keysize = Integer.parseInt(text.trim());
                this.ephmeralKey = new byte[this.keysize];
            }
            catch (NumberFormatException e) {
                throw new TrustException("InvalidRequest", new String[]{"invalid wst:Keysize value"}, e);
            }
        }
        this.keysize = -1;
    }

    private void processEntropy() throws TrustException {
        OMElement entropyElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "Entropy"));
        if (entropyElem != null) {
            OMElement binSecElem = entropyElem.getFirstElement();
            if (binSecElem != null && binSecElem.getText() != null && !"".equals(binSecElem.getText())) {
                this.requestEntropy = Base64.decode((String)binSecElem.getText());
            } else {
                throw new TrustException("malformedEntropyElement", new String[]{entropyElem.toString()});
            }
        }
    }

    public String getAppliesToAddress() {
        return this.appliesToAddress;
    }

    public X509Certificate getClientCert() {
        return this.clientCert;
    }

    public String getComputedKeyAlgo() {
        return this.computedKeyAlgo;
    }

    public byte[] getEphmeralKey() {
        return this.ephmeralKey;
    }

    public MessageContext getInMessageContext() {
        return this.inMessageContext;
    }

    public int getKeysize() {
        return this.keysize;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public byte[] getRequestEntropy() {
        return this.requestEntropy;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public byte[] getResponseEntropy() {
        return this.responseEntropy;
    }

    public OMElement getRstElement() {
        return this.rstElement;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public int getVersion() {
        return this.version;
    }

    public String getAddressingNs() {
        return this.addressingNs;
    }

    public String getWstNs() {
        return this.wstNs;
    }

    public String getSoapNs() {
        return this.soapNs;
    }

    public void setResponseEntropy(byte[] responseEntropy) {
        this.responseEntropy = responseEntropy;
    }

    public void setEphmeralKey(byte[] ephmeralKey) {
        this.ephmeralKey = ephmeralKey;
    }
}

