/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.AbstractIssuerConfig;

public class SAMLTokenIssuerConfig
extends AbstractIssuerConfig {
    public static final QName SAML_ISSUER_CONFIG = new QName("saml-issuer-config");
    private static final QName ISSUER_KEY_ALIAS = new QName("issuerKeyAlias");
    private static final QName ISSUER_KEY_PASSWD = new QName("issuerKeyPassword");
    private static final QName TTL = new QName("timeToLive");
    private static final QName TRUSTED_SERVICES = new QName("trusted-services");
    private static final QName KEY_SIZE = new QName("keySize");
    private static final QName SERVICE = new QName("service");
    private static final QName ALIAS = new QName("alias");
    public static final QName USE_SAML_ATTRIBUTE_STATEMENT = new QName("useSAMLAttributeStatement");
    public static final QName ISSUER_NAME = new QName("issuerName");
    protected String issuerKeyAlias;
    protected String issuerKeyPassword;
    protected String issuerName;
    protected Map trustedServices;
    protected String trustStorePropFile;

    private SAMLTokenIssuerConfig(OMElement elem) throws TrustException {
        OMElement keySizeElem;
        OMElement ttlElem;
        OMElement keyCompElem;
        OMElement userElem;
        OMElement proofKeyElem = elem.getFirstChildWithName(PROOF_KEY_TYPE);
        if (proofKeyElem != null) {
            this.proofKeyType = proofKeyElem.getText().trim();
        }
        if ((userElem = elem.getFirstChildWithName(ISSUER_KEY_ALIAS)) != null) {
            this.issuerKeyAlias = userElem.getText().trim();
        }
        if (this.issuerKeyAlias == null || "".equals(this.issuerKeyAlias)) {
            throw new TrustException("samlIssuerKeyAliasMissing");
        }
        OMElement issuerKeyPasswdElem = elem.getFirstChildWithName(ISSUER_KEY_PASSWD);
        if (issuerKeyPasswdElem != null) {
            this.issuerKeyPassword = issuerKeyPasswdElem.getText().trim();
        }
        if (this.issuerKeyPassword == null || "".equals(this.issuerKeyPassword)) {
            throw new TrustException("samlIssuerKeyPasswdMissing");
        }
        OMElement issuerNameElem = elem.getFirstChildWithName(ISSUER_NAME);
        if (issuerNameElem != null) {
            this.issuerName = issuerNameElem.getText().trim();
        }
        if (this.issuerName == null || "".equals(this.issuerName)) {
            throw new TrustException("samlIssuerNameMissing");
        }
        OMElement cryptoPropElem = elem.getFirstChildWithName(CRYPTO_PROPERTIES);
        if (cryptoPropElem != null && (this.cryptoPropertiesElement = cryptoPropElem.getFirstChildWithName(CRYPTO)) == null) {
            this.cryptoPropertiesFile = cryptoPropElem.getText().trim();
        }
        if ((keyCompElem = elem.getFirstChildWithName(AbstractIssuerConfig.KeyComputation.KEY_COMPUTATION)) != null && keyCompElem.getText() != null && !"".equals(keyCompElem)) {
            this.keyComputation = Integer.parseInt(keyCompElem.getText());
        }
        if ((ttlElem = elem.getFirstChildWithName(TTL)) != null) {
            try {
                this.ttl = Long.parseLong(ttlElem.getText().trim());
            }
            catch (NumberFormatException e) {
                throw new TrustException("invlidTTL");
            }
        }
        if ((keySizeElem = elem.getFirstChildWithName(KEY_SIZE)) != null) {
            try {
                this.keySize = Integer.parseInt(keySizeElem.getText().trim());
            }
            catch (NumberFormatException e) {
                throw new TrustException("invalidKeysize");
            }
        }
        this.addRequestedAttachedRef = elem.getFirstChildWithName(ADD_REQUESTED_ATTACHED_REF) != null;
        this.addRequestedUnattachedRef = elem.getFirstChildWithName(ADD_REQUESTED_UNATTACHED_REF) != null;
        OMElement trustedServices = elem.getFirstChildWithName(TRUSTED_SERVICES);
        if (trustedServices != null) {
            Iterator servicesIter = trustedServices.getChildrenWithName(SERVICE);
            while (servicesIter.hasNext()) {
                OMElement service = (OMElement)servicesIter.next();
                OMAttribute aliasAttr = service.getAttribute(ALIAS);
                if (aliasAttr == null) {
                    throw new TrustException("aliasMissingForService", new String[]{service.getText().trim()});
                }
                if (this.trustedServices == null) {
                    this.trustedServices = new HashMap();
                }
                this.trustedServices.put(service.getText().trim(), aliasAttr.getAttributeValue());
            }
        }
    }

    public static SAMLTokenIssuerConfig load(OMElement elem) throws TrustException {
        return new SAMLTokenIssuerConfig(elem);
    }

    public static SAMLTokenIssuerConfig load(String configFilePath) throws TrustException {
        StAXOMBuilder builder;
        try {
            FileInputStream fis = new FileInputStream(configFilePath);
            builder = new StAXOMBuilder((InputStream)fis);
        }
        catch (Exception e) {
            throw new TrustException("errorLoadingConfigFile", new String[]{configFilePath});
        }
        return SAMLTokenIssuerConfig.load(builder.getDocumentElement());
    }
}

