/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenCanceler;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SCTIssuerConfig;
import org.apache.rahas.impl.TokenCancelerConfig;

public class TokenCancelerImpl
implements TokenCanceler {
    private String configFile;
    private OMElement configElement;
    private String configParamName;
    private static final QName QNAME_CANCEL_TARGET = new QName("CancelTarget");
    private static final QName QNAME_SEC_TOKEN_REF = new QName("SecurityTokenReference");
    private static final QName QNAME_REFERENCE = new QName("Reference");
    private static final QName QNAME_URI = new QName("URI");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SOAPEnvelope cancel(RahasData data) throws TrustException {
        OMElement rstrElem;
        TokenCancelerConfig config = null;
        if (this.configElement != null) {
            config = TokenCancelerConfig.load(this.configElement.getFirstChildWithName(SCTIssuerConfig.SCT_ISSUER_CONFIG));
        }
        if (config == null && this.configFile != null) {
            config = TokenCancelerConfig.load(this.configFile);
        }
        if (config == null && this.configParamName != null) {
            Parameter param = data.getInMessageContext().getParameter(this.configParamName);
            if (param == null || param.getParameterElement() == null) throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
            config = TokenCancelerConfig.load(param.getParameterElement().getFirstChildWithName(SCTIssuerConfig.SCT_ISSUER_CONFIG));
        }
        if (config == null) {
            throw new TrustException("missingConfiguration", new String[]{SCTIssuerConfig.SCT_ISSUER_CONFIG.getLocalPart()});
        }
        OMElement rstEle = data.getRstElement();
        OMElement cancelTargetEle = rstEle.getFirstChildWithName(QNAME_CANCEL_TARGET);
        if (cancelTargetEle == null) {
            throw new TrustException("requiredElementNotFound", new String[]{QNAME_CANCEL_TARGET.getLocalPart()});
        }
        OMElement secTokenRefEle = cancelTargetEle.getFirstChildWithName(QNAME_SEC_TOKEN_REF);
        if (secTokenRefEle == null) throw new TrustException("cannotDetermineTokenId");
        OMElement referenceEle = secTokenRefEle.getFirstChildWithName(QNAME_REFERENCE);
        if (referenceEle == null) throw new TrustException("cannotDetermineTokenId");
        OMAttribute uri = referenceEle.getAttribute(QNAME_URI);
        if (uri == null) {
            throw new TrustException("cannotDetermineTokenId");
        }
        String tokenId = uri.getAttributeValue().substring(1);
        MessageContext inMsgCtx = data.getInMessageContext();
        TokenStorage tokenStore = TrustUtil.getTokenStore(inMsgCtx);
        Token token = tokenStore.getToken(tokenId);
        if (token == null) {
            throw new TrustException("tokenNotFound", new String[]{tokenId});
        }
        token.setState(3);
        tokenStore.update(token);
        SOAPEnvelope responseEnv = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
        int version = data.getVersion();
        if (1 == version) {
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(version, (OMElement)responseEnv.getBody());
        } else {
            OMElement rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(version, (OMElement)responseEnv.getBody());
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(version, rstrcElem);
        }
        OMElement reqTokenCanceledEle = TrustUtil.createRequestedTokenCanceledElement(version, rstrElem);
        return responseEnv;
    }

    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }

    public String getResponseAction(RahasData data) throws TrustException {
        return TrustUtil.getActionValue(data.getVersion(), "/RSTR/Cancel");
    }
}

