/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;

final class AutoValue_GoogleCloudStorageReadOptions
extends GoogleCloudStorageReadOptions {
    private final int backoffInitialIntervalMillis;
    private final double backoffRandomizationFactor;
    private final double backoffMultiplier;
    private final int backoffMaxIntervalMillis;
    private final int backoffMaxElapsedTimeMillis;
    private final boolean fastFailOnNotFound;
    private final int bufferSize;
    private final long inplaceSeekLimit;
    private final GoogleCloudStorageReadOptions.Fadvise fadvise;
    private final int minRangeRequestSize;
    private final GoogleCloudStorageReadOptions.GenerationReadConsistency generationReadConsistency;

    private AutoValue_GoogleCloudStorageReadOptions(int backoffInitialIntervalMillis, double backoffRandomizationFactor, double backoffMultiplier, int backoffMaxIntervalMillis, int backoffMaxElapsedTimeMillis, boolean fastFailOnNotFound, int bufferSize, long inplaceSeekLimit, GoogleCloudStorageReadOptions.Fadvise fadvise, int minRangeRequestSize, GoogleCloudStorageReadOptions.GenerationReadConsistency generationReadConsistency) {
        this.backoffInitialIntervalMillis = backoffInitialIntervalMillis;
        this.backoffRandomizationFactor = backoffRandomizationFactor;
        this.backoffMultiplier = backoffMultiplier;
        this.backoffMaxIntervalMillis = backoffMaxIntervalMillis;
        this.backoffMaxElapsedTimeMillis = backoffMaxElapsedTimeMillis;
        this.fastFailOnNotFound = fastFailOnNotFound;
        this.bufferSize = bufferSize;
        this.inplaceSeekLimit = inplaceSeekLimit;
        this.fadvise = fadvise;
        this.minRangeRequestSize = minRangeRequestSize;
        this.generationReadConsistency = generationReadConsistency;
    }

    @Override
    public int getBackoffInitialIntervalMillis() {
        return this.backoffInitialIntervalMillis;
    }

    @Override
    public double getBackoffRandomizationFactor() {
        return this.backoffRandomizationFactor;
    }

    @Override
    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    @Override
    public int getBackoffMaxIntervalMillis() {
        return this.backoffMaxIntervalMillis;
    }

    @Override
    public int getBackoffMaxElapsedTimeMillis() {
        return this.backoffMaxElapsedTimeMillis;
    }

    @Override
    public boolean getFastFailOnNotFound() {
        return this.fastFailOnNotFound;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public long getInplaceSeekLimit() {
        return this.inplaceSeekLimit;
    }

    @Override
    public GoogleCloudStorageReadOptions.Fadvise getFadvise() {
        return this.fadvise;
    }

    @Override
    public int getMinRangeRequestSize() {
        return this.minRangeRequestSize;
    }

    @Override
    public GoogleCloudStorageReadOptions.GenerationReadConsistency getGenerationReadConsistency() {
        return this.generationReadConsistency;
    }

    public String toString() {
        return "GoogleCloudStorageReadOptions{backoffInitialIntervalMillis=" + this.backoffInitialIntervalMillis + ", backoffRandomizationFactor=" + this.backoffRandomizationFactor + ", backoffMultiplier=" + this.backoffMultiplier + ", backoffMaxIntervalMillis=" + this.backoffMaxIntervalMillis + ", backoffMaxElapsedTimeMillis=" + this.backoffMaxElapsedTimeMillis + ", fastFailOnNotFound=" + this.fastFailOnNotFound + ", bufferSize=" + this.bufferSize + ", inplaceSeekLimit=" + this.inplaceSeekLimit + ", fadvise=" + (Object)((Object)this.fadvise) + ", minRangeRequestSize=" + this.minRangeRequestSize + ", generationReadConsistency=" + (Object)((Object)this.generationReadConsistency) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GoogleCloudStorageReadOptions) {
            GoogleCloudStorageReadOptions that = (GoogleCloudStorageReadOptions)o;
            return this.backoffInitialIntervalMillis == that.getBackoffInitialIntervalMillis() && Double.doubleToLongBits(this.backoffRandomizationFactor) == Double.doubleToLongBits(that.getBackoffRandomizationFactor()) && Double.doubleToLongBits(this.backoffMultiplier) == Double.doubleToLongBits(that.getBackoffMultiplier()) && this.backoffMaxIntervalMillis == that.getBackoffMaxIntervalMillis() && this.backoffMaxElapsedTimeMillis == that.getBackoffMaxElapsedTimeMillis() && this.fastFailOnNotFound == that.getFastFailOnNotFound() && this.bufferSize == that.getBufferSize() && this.inplaceSeekLimit == that.getInplaceSeekLimit() && this.fadvise.equals((Object)that.getFadvise()) && this.minRangeRequestSize == that.getMinRangeRequestSize() && this.generationReadConsistency.equals((Object)that.getGenerationReadConsistency());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.backoffInitialIntervalMillis;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.backoffRandomizationFactor) >>> 32 ^ Double.doubleToLongBits(this.backoffRandomizationFactor));
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.backoffMultiplier) >>> 32 ^ Double.doubleToLongBits(this.backoffMultiplier));
        h$ *= 1000003;
        h$ ^= this.backoffMaxIntervalMillis;
        h$ *= 1000003;
        h$ ^= this.backoffMaxElapsedTimeMillis;
        h$ *= 1000003;
        h$ ^= this.fastFailOnNotFound ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.bufferSize;
        h$ *= 1000003;
        h$ ^= (int)(this.inplaceSeekLimit >>> 32 ^ this.inplaceSeekLimit);
        h$ *= 1000003;
        h$ ^= this.fadvise.hashCode();
        h$ *= 1000003;
        h$ ^= this.minRangeRequestSize;
        h$ *= 1000003;
        return h$ ^= this.generationReadConsistency.hashCode();
    }

    @Override
    public GoogleCloudStorageReadOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends GoogleCloudStorageReadOptions.Builder {
        private Integer backoffInitialIntervalMillis;
        private Double backoffRandomizationFactor;
        private Double backoffMultiplier;
        private Integer backoffMaxIntervalMillis;
        private Integer backoffMaxElapsedTimeMillis;
        private Boolean fastFailOnNotFound;
        private Integer bufferSize;
        private Long inplaceSeekLimit;
        private GoogleCloudStorageReadOptions.Fadvise fadvise;
        private Integer minRangeRequestSize;
        private GoogleCloudStorageReadOptions.GenerationReadConsistency generationReadConsistency;

        Builder() {
        }

        private Builder(GoogleCloudStorageReadOptions source) {
            this.backoffInitialIntervalMillis = source.getBackoffInitialIntervalMillis();
            this.backoffRandomizationFactor = source.getBackoffRandomizationFactor();
            this.backoffMultiplier = source.getBackoffMultiplier();
            this.backoffMaxIntervalMillis = source.getBackoffMaxIntervalMillis();
            this.backoffMaxElapsedTimeMillis = source.getBackoffMaxElapsedTimeMillis();
            this.fastFailOnNotFound = source.getFastFailOnNotFound();
            this.bufferSize = source.getBufferSize();
            this.inplaceSeekLimit = source.getInplaceSeekLimit();
            this.fadvise = source.getFadvise();
            this.minRangeRequestSize = source.getMinRangeRequestSize();
            this.generationReadConsistency = source.getGenerationReadConsistency();
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBackoffInitialIntervalMillis(int backoffInitialIntervalMillis) {
            this.backoffInitialIntervalMillis = backoffInitialIntervalMillis;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBackoffRandomizationFactor(double backoffRandomizationFactor) {
            this.backoffRandomizationFactor = backoffRandomizationFactor;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBackoffMultiplier(double backoffMultiplier) {
            this.backoffMultiplier = backoffMultiplier;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBackoffMaxIntervalMillis(int backoffMaxIntervalMillis) {
            this.backoffMaxIntervalMillis = backoffMaxIntervalMillis;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBackoffMaxElapsedTimeMillis(int backoffMaxElapsedTimeMillis) {
            this.backoffMaxElapsedTimeMillis = backoffMaxElapsedTimeMillis;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setFastFailOnNotFound(boolean fastFailOnNotFound) {
            this.fastFailOnNotFound = fastFailOnNotFound;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setInplaceSeekLimit(long inplaceSeekLimit) {
            this.inplaceSeekLimit = inplaceSeekLimit;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setFadvise(GoogleCloudStorageReadOptions.Fadvise fadvise) {
            if (fadvise == null) {
                throw new NullPointerException("Null fadvise");
            }
            this.fadvise = fadvise;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setMinRangeRequestSize(int minRangeRequestSize) {
            this.minRangeRequestSize = minRangeRequestSize;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setGenerationReadConsistency(GoogleCloudStorageReadOptions.GenerationReadConsistency generationReadConsistency) {
            if (generationReadConsistency == null) {
                throw new NullPointerException("Null generationReadConsistency");
            }
            this.generationReadConsistency = generationReadConsistency;
            return this;
        }

        @Override
        GoogleCloudStorageReadOptions autoBuild() {
            String missing = "";
            if (this.backoffInitialIntervalMillis == null) {
                missing = missing + " backoffInitialIntervalMillis";
            }
            if (this.backoffRandomizationFactor == null) {
                missing = missing + " backoffRandomizationFactor";
            }
            if (this.backoffMultiplier == null) {
                missing = missing + " backoffMultiplier";
            }
            if (this.backoffMaxIntervalMillis == null) {
                missing = missing + " backoffMaxIntervalMillis";
            }
            if (this.backoffMaxElapsedTimeMillis == null) {
                missing = missing + " backoffMaxElapsedTimeMillis";
            }
            if (this.fastFailOnNotFound == null) {
                missing = missing + " fastFailOnNotFound";
            }
            if (this.bufferSize == null) {
                missing = missing + " bufferSize";
            }
            if (this.inplaceSeekLimit == null) {
                missing = missing + " inplaceSeekLimit";
            }
            if (this.fadvise == null) {
                missing = missing + " fadvise";
            }
            if (this.minRangeRequestSize == null) {
                missing = missing + " minRangeRequestSize";
            }
            if (this.generationReadConsistency == null) {
                missing = missing + " generationReadConsistency";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GoogleCloudStorageReadOptions(this.backoffInitialIntervalMillis, this.backoffRandomizationFactor, this.backoffMultiplier, this.backoffMaxIntervalMillis, this.backoffMaxElapsedTimeMillis, this.fastFailOnNotFound, this.bufferSize, this.inplaceSeekLimit, this.fadvise, this.minRangeRequestSize, this.generationReadConsistency);
        }
    }
}

