/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.collect.ImmutableMap;

public class CreateFileOptions {
    public static final ImmutableMap<String, byte[]> EMPTY_ATTRIBUTES = ImmutableMap.of();
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final CreateFileOptions DEFAULT = new CreateFileOptions(true, "application/octet-stream", EMPTY_ATTRIBUTES);
    private final boolean overwriteExisting;
    private final String contentType;
    private final Map<String, byte[]> attributes;
    private final boolean checkNoDirectoryConflict;
    private final boolean ensureParentDirectoriesExist;
    private final long existingGenerationId;

    public CreateFileOptions(boolean overwriteExisting) {
        this(overwriteExisting, DEFAULT_CONTENT_TYPE, EMPTY_ATTRIBUTES);
    }

    public CreateFileOptions(boolean overwriteExisting, String contentType) {
        this(overwriteExisting, contentType, EMPTY_ATTRIBUTES);
    }

    public CreateFileOptions(boolean overwriteExisting, Map<String, byte[]> attributes) {
        this(overwriteExisting, DEFAULT_CONTENT_TYPE, attributes);
    }

    public CreateFileOptions(boolean overwriteExisting, String contentType, Map<String, byte[]> attributes) {
        this(overwriteExisting, contentType, attributes, true, true, -1L);
    }

    public CreateFileOptions(boolean overwriteExisting, String contentType, Map<String, byte[]> attributes, boolean checkNoDirectoryConflict, boolean ensureParentDirectoriesExist, long existingGenerationId) {
        Preconditions.checkArgument(!attributes.containsKey("Content-Type"), "The Content-Type attribute must be provided explicitly via the 'contentType' parameter");
        this.overwriteExisting = overwriteExisting;
        this.contentType = contentType;
        this.attributes = attributes;
        this.checkNoDirectoryConflict = checkNoDirectoryConflict;
        this.ensureParentDirectoriesExist = ensureParentDirectoriesExist;
        this.existingGenerationId = existingGenerationId;
    }

    public boolean overwriteExisting() {
        return this.overwriteExisting;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, byte[]> getAttributes() {
        return this.attributes;
    }

    public boolean checkNoDirectoryConflict() {
        return this.checkNoDirectoryConflict;
    }

    public boolean ensureParentDirectoriesExist() {
        return this.ensureParentDirectoriesExist;
    }

    public long getExistingGenerationId() {
        return this.existingGenerationId;
    }
}

