/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.Clock;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.PathCodec;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.base.Strings;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.GoogleLogger;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.primitives.Longs;

public class FileInfo {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final FileInfo ROOT_INFO = new FileInfo(GoogleCloudStorageFileSystem.GCS_ROOT, GoogleCloudStorageItemInfo.ROOT_INFO);
    public static final String FILE_MODIFICATION_TIMESTAMP_KEY = "system.gcsfs_mts";
    private final URI path;
    private final GoogleCloudStorageItemInfo itemInfo;
    private final Map<String, byte[]> attributes;

    private FileInfo(URI path, GoogleCloudStorageItemInfo itemInfo) {
        this.itemInfo = itemInfo;
        this.path = path;
        Preconditions.checkArgument(itemInfo.getMetadata() != null);
        this.attributes = itemInfo.getMetadata();
    }

    public URI getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return FileInfo.isDirectory(this.itemInfo);
    }

    static boolean isDirectory(GoogleCloudStorageItemInfo itemInfo) {
        return FileInfo.isGlobalRoot(itemInfo) || itemInfo.isBucket() || FileInfo.objectHasDirectoryPath(itemInfo.getObjectName());
    }

    public boolean isGlobalRoot() {
        return FileInfo.isGlobalRoot(this.itemInfo);
    }

    static boolean isGlobalRoot(GoogleCloudStorageItemInfo itemInfo) {
        return itemInfo.isRoot() && itemInfo.exists();
    }

    public long getCreationTime() {
        return this.itemInfo.getCreationTime();
    }

    public long getSize() {
        return this.itemInfo.getSize();
    }

    public long getModificationTime() {
        if (this.attributes.containsKey(FILE_MODIFICATION_TIMESTAMP_KEY) && this.attributes.get(FILE_MODIFICATION_TIMESTAMP_KEY) != null) {
            try {
                return Longs.fromByteArray(this.attributes.get(FILE_MODIFICATION_TIMESTAMP_KEY));
            }
            catch (IllegalArgumentException iae) {
                ((GoogleLogger.Api)logger.atFine()).log("Failed to parse modification time '%s' millis for object %s", (Object)this.attributes.get(FILE_MODIFICATION_TIMESTAMP_KEY), (Object)this.itemInfo.getObjectName());
            }
        }
        return this.getCreationTime();
    }

    public Map<String, byte[]> getAttributes() {
        return this.attributes;
    }

    public boolean exists() {
        return this.itemInfo.exists();
    }

    public String toString() {
        if (this.exists()) {
            return this.getPath() + ": created on: " + new Date(this.getCreationTime());
        }
        return this.getPath() + ": exists: no";
    }

    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.itemInfo;
    }

    static boolean objectHasDirectoryPath(String objectName) {
        return StorageResourceId.objectHasDirectoryPath(objectName);
    }

    static String convertToDirectoryPath(String objectName) {
        return StorageResourceId.convertToDirectoryPath(objectName);
    }

    public static void addModificationTimeToAttributes(Map<String, byte[]> attributes, Clock clock) {
        attributes.put(FILE_MODIFICATION_TIMESTAMP_KEY, Longs.toByteArray(clock.currentTimeMillis()));
    }

    public static String convertToFilePath(String objectName) {
        if (!Strings.isNullOrEmpty(objectName) && FileInfo.objectHasDirectoryPath(objectName)) {
            objectName = objectName.substring(0, objectName.length() - 1);
        }
        return objectName;
    }

    public static FileInfo fromItemInfo(PathCodec pathCodec, GoogleCloudStorageItemInfo itemInfo) {
        if (itemInfo.isRoot()) {
            return ROOT_INFO;
        }
        URI path = pathCodec.getPath(itemInfo.getBucketName(), itemInfo.getObjectName(), true);
        return new FileInfo(path, itemInfo);
    }

    public static List<FileInfo> fromItemInfos(PathCodec pathCodec, List<GoogleCloudStorageItemInfo> itemInfos) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>(itemInfos.size());
        for (GoogleCloudStorageItemInfo itemInfo : itemInfos) {
            fileInfos.add(FileInfo.fromItemInfo(pathCodec, itemInfo));
        }
        return fileInfos;
    }

    public static boolean isDirectoryPath(URI path) {
        return path != null && path.toString().endsWith("/");
    }

    public static StorageResourceId convertToDirectoryPath(StorageResourceId resourceId) {
        if (resourceId.isStorageObject() && !FileInfo.objectHasDirectoryPath(resourceId.getObjectName())) {
            resourceId = new StorageResourceId(resourceId.getBucketName(), FileInfo.convertToDirectoryPath(resourceId.getObjectName()));
        }
        return resourceId;
    }

    public static URI convertToDirectoryPath(PathCodec pathCodec, URI path) {
        StorageResourceId resourceId = pathCodec.validatePathAndGetId(path, true);
        if (resourceId.isStorageObject() && !FileInfo.objectHasDirectoryPath(resourceId.getObjectName())) {
            resourceId = FileInfo.convertToDirectoryPath(resourceId);
            path = pathCodec.getPath(resourceId.getBucketName(), resourceId.getObjectName(), false);
        }
        return path;
    }
}

