/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.services.storage.Storage;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.base.Optional;

public class ObjectWriteConditions {
    public static final ObjectWriteConditions NONE = new ObjectWriteConditions();
    private final Optional<Long> contentGenerationMatch;
    private final Optional<Long> metaGenerationMatch;

    public ObjectWriteConditions() {
        this.metaGenerationMatch = Optional.absent();
        this.contentGenerationMatch = Optional.absent();
    }

    public ObjectWriteConditions(Optional<Long> contentGenerationMatch, Optional<Long> metaGenerationMatch) {
        this.contentGenerationMatch = contentGenerationMatch;
        this.metaGenerationMatch = metaGenerationMatch;
    }

    public boolean hasContentGenerationMatch() {
        return this.contentGenerationMatch.isPresent();
    }

    public boolean hasMetaGenerationMatch() {
        return this.metaGenerationMatch.isPresent();
    }

    public long getContentGenerationMatch() {
        return this.contentGenerationMatch.get();
    }

    public long getMetaGenerationMatch() {
        return this.metaGenerationMatch.get();
    }

    public void apply(Storage.Objects.Insert objectToInsert) {
        if (this.hasContentGenerationMatch()) {
            objectToInsert.setIfGenerationMatch(this.getContentGenerationMatch());
        }
        if (this.hasMetaGenerationMatch()) {
            objectToInsert.setIfMetagenerationMatch(this.getMetaGenerationMatch());
        }
    }
}

