/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.EnumSet;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.util.concurrent.RateLimiter;

public class ThrottledGoogleCloudStorage
implements GoogleCloudStorage {
    private final RateLimiter rateLimiter;
    private final GoogleCloudStorage wrappedGcs;
    private final EnumSet<StorageOperation> throttledOperations;

    public ThrottledGoogleCloudStorage(GoogleCloudStorage wrappedGcs, RateLimiter rateLimiter) {
        this(rateLimiter, wrappedGcs, EnumSet.allOf(StorageOperation.class));
    }

    public ThrottledGoogleCloudStorage(double operationsPerSecond, GoogleCloudStorage wrappedGcs, EnumSet<StorageOperation> throttledOperations) {
        this(RateLimiter.create(operationsPerSecond), wrappedGcs, throttledOperations);
    }

    public ThrottledGoogleCloudStorage(RateLimiter rateLimiter, GoogleCloudStorage wrappedGcs, EnumSet<StorageOperation> throttledOperations) {
        this.rateLimiter = rateLimiter;
        this.wrappedGcs = wrappedGcs;
        this.throttledOperations = throttledOperations;
    }

    private void throttle(StorageOperation operation) {
        this.throttle(operation, 1);
    }

    private void throttle(StorageOperation operation, int permits) {
        if (this.throttledOperations.contains((Object)operation) && permits > 0) {
            this.rateLimiter.acquire(permits);
        }
    }

    @Override
    public GoogleCloudStorageOptions getOptions() {
        return this.wrappedGcs.getOptions();
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId) throws IOException {
        this.throttle(StorageOperation.CREATE_OBJECT);
        return this.wrappedGcs.create(resourceId);
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        this.throttle(StorageOperation.CREATE_OBJECT);
        return this.wrappedGcs.create(resourceId, options);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        this.throttle(StorageOperation.CREATE_OBJECT);
        this.wrappedGcs.createEmptyObject(resourceId);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        this.throttle(StorageOperation.CREATE_OBJECT);
        this.wrappedGcs.createEmptyObject(resourceId, options);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        this.throttle(StorageOperation.CREATE_OBJECT, resourceIds.size());
        this.wrappedGcs.createEmptyObjects(resourceIds);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        this.throttle(StorageOperation.CREATE_OBJECT, resourceIds.size());
        this.wrappedGcs.createEmptyObjects(resourceIds, options);
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId) throws IOException {
        this.throttle(StorageOperation.OPEN_OBJECT);
        return this.wrappedGcs.open(resourceId);
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        this.throttle(StorageOperation.OPEN_OBJECT);
        return this.wrappedGcs.open(resourceId, readOptions);
    }

    @Override
    public void create(String bucketName) throws IOException {
        this.throttle(StorageOperation.CREATE_BUCKET);
        this.wrappedGcs.create(bucketName);
    }

    @Override
    public void create(String bucketName, CreateBucketOptions options) throws IOException {
        this.throttle(StorageOperation.CREATE_BUCKET);
        this.wrappedGcs.create(bucketName, options);
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        this.throttle(StorageOperation.DELETE_BUCKETS, bucketNames.size());
        this.wrappedGcs.deleteBuckets(bucketNames);
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        this.throttle(StorageOperation.DELETE_OBJECTS, fullObjectNames.size());
        this.wrappedGcs.deleteObjects(fullObjectNames);
    }

    @Override
    public void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        this.throttle(StorageOperation.COPY_OBJECT, srcObjectNames.size());
        this.wrappedGcs.copy(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames);
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        this.throttle(StorageOperation.LIST_BUCKETS);
        return this.wrappedGcs.listBucketNames();
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        this.throttle(StorageOperation.LIST_BUCKETS);
        return this.wrappedGcs.listBucketInfo();
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectNames(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        this.throttle(StorageOperation.LIST_OBJECTS);
        return this.wrappedGcs.listObjectNames(bucketName, objectNamePrefix, delimiter, maxResults);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectInfo(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        this.throttle(StorageOperation.LIST_OBJECTS);
        return this.wrappedGcs.listObjectInfo(bucketName, objectNamePrefix, delimiter, maxResults);
    }

    @Override
    public GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> listObjectInfoPage(String bucketName, String objectNamePrefix, String delimiter, String pageToken) throws IOException {
        this.throttle(StorageOperation.LIST_OBJECTS);
        return this.wrappedGcs.listObjectInfoPage(bucketName, objectNamePrefix, delimiter, pageToken);
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        this.throttle(StorageOperation.GET_ITEMINFO);
        return this.wrappedGcs.getItemInfo(resourceId);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        this.throttle(StorageOperation.GET_ITEMINFO, resourceIds.size());
        return this.wrappedGcs.getItemInfos(resourceIds);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        this.throttle(StorageOperation.UPDATE_ITEMINFO, itemInfoList.size());
        return this.wrappedGcs.updateItems(itemInfoList);
    }

    @Override
    public void close() {
        this.wrappedGcs.close();
    }

    @Override
    public void waitForBucketEmpty(String bucketName) throws IOException {
        this.throttle(StorageOperation.LIST_OBJECTS);
        this.wrappedGcs.waitForBucketEmpty(bucketName);
    }

    @Override
    public void compose(String bucketName, List<String> sources, String destination, String contentType) throws IOException {
        this.throttle(StorageOperation.GET_ITEMINFO, sources.size());
        this.throttle(StorageOperation.COMPOSE_OBJECTS);
        this.wrappedGcs.compose(bucketName, sources, destination, contentType);
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        this.throttle(StorageOperation.GET_ITEMINFO, sources.size());
        this.throttle(StorageOperation.COMPOSE_OBJECTS);
        return this.wrappedGcs.composeObjects(sources, destination, options);
    }

    public static enum StorageOperation {
        CREATE_BUCKET,
        DELETE_BUCKETS,
        CREATE_OBJECT,
        COMPOSE_OBJECTS,
        DELETE_OBJECTS,
        OPEN_OBJECT,
        COPY_OBJECT,
        LIST_BUCKETS,
        LIST_OBJECTS,
        GET_ITEMINFO,
        UPDATE_ITEMINFO;

    }
}

