/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.testing;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.base.Preconditions;

public class InMemoryObjectReadChannel
extends GoogleCloudStorageReadChannel {
    private final byte[] content;

    public InMemoryObjectReadChannel(byte[] content) throws IOException {
        this(content, GoogleCloudStorageReadOptions.DEFAULT);
    }

    public InMemoryObjectReadChannel(byte[] content, GoogleCloudStorageReadOptions readOptions) throws IOException {
        super(readOptions);
        this.content = Preconditions.checkNotNull(content, "channelContents could not be null");
    }

    @Override
    protected InputStream openStream(long bytesToRead) throws IOException {
        if (this.size() == -1L && this.content.length == 0 && this.currentPosition == 0L) {
            this.setSize(this.content.length);
        } else {
            this.setSize(this.content.length);
            this.validatePosition(this.currentPosition);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.content);
        ((InputStream)inputStream).skip(this.currentPosition);
        this.contentChannelPosition = this.currentPosition;
        return inputStream;
    }
}

